// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ChangeTrustAsset's original definition in the XDR file is:
 *
 * <pre>
 * union ChangeTrustAsset switch (AssetType type)
 * {
 * case ASSET_TYPE_NATIVE: // Not credit
 *     void;
 *
 * case ASSET_TYPE_CREDIT_ALPHANUM4:
 *     AlphaNum4 alphaNum4;
 *
 * case ASSET_TYPE_CREDIT_ALPHANUM12:
 *     AlphaNum12 alphaNum12;
 *
 * case ASSET_TYPE_POOL_SHARE:
 *     LiquidityPoolParameters liquidityPool;
 *
 *     // add other asset types here in the future
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ChangeTrustAsset implements XdrElement {
  private AssetType discriminant;
  private AlphaNum4 alphaNum4;
  private AlphaNum12 alphaNum12;
  private LiquidityPoolParameters liquidityPool;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        alphaNum4.encode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        alphaNum12.encode(stream);
        break;
      case ASSET_TYPE_POOL_SHARE:
        liquidityPool.encode(stream);
        break;
    }
  }

  public static ChangeTrustAsset decode(XdrDataInputStream stream) throws IOException {
    ChangeTrustAsset decodedChangeTrustAsset = new ChangeTrustAsset();
    AssetType discriminant = AssetType.decode(stream);
    decodedChangeTrustAsset.setDiscriminant(discriminant);
    switch (decodedChangeTrustAsset.getDiscriminant()) {
      case ASSET_TYPE_NATIVE:
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM4:
        decodedChangeTrustAsset.alphaNum4 = AlphaNum4.decode(stream);
        break;
      case ASSET_TYPE_CREDIT_ALPHANUM12:
        decodedChangeTrustAsset.alphaNum12 = AlphaNum12.decode(stream);
        break;
      case ASSET_TYPE_POOL_SHARE:
        decodedChangeTrustAsset.liquidityPool = LiquidityPoolParameters.decode(stream);
        break;
    }
    return decodedChangeTrustAsset;
  }

  public static ChangeTrustAsset fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ChangeTrustAsset fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
