// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ContractCodeEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct ContractCodeEntry {
 *     union switch (int v)
 *     {
 *         case 0:
 *             void;
 *         case 1:
 *             struct
 *             {
 *                 ExtensionPoint ext;
 *                 ContractCodeCostInputs costInputs;
 *             } v1;
 *     } ext;
 *
 *     Hash hash;
 *     opaque code&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ContractCodeEntry implements XdrElement {
  private ContractCodeEntryExt ext;
  private Hash hash;
  private byte[] code;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    hash.encode(stream);
    int codeSize = code.length;
    stream.writeInt(codeSize);
    stream.write(getCode(), 0, codeSize);
  }

  public static ContractCodeEntry decode(XdrDataInputStream stream) throws IOException {
    ContractCodeEntry decodedContractCodeEntry = new ContractCodeEntry();
    decodedContractCodeEntry.ext = ContractCodeEntryExt.decode(stream);
    decodedContractCodeEntry.hash = Hash.decode(stream);
    int codeSize = stream.readInt();
    decodedContractCodeEntry.code = new byte[codeSize];
    stream.read(decodedContractCodeEntry.code, 0, codeSize);
    return decodedContractCodeEntry;
  }

  public static ContractCodeEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ContractCodeEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * ContractCodeEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *         case 0:
   *             void;
   *         case 1:
   *             struct
   *             {
   *                 ExtensionPoint ext;
   *                 ContractCodeCostInputs costInputs;
   *             } v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class ContractCodeEntryExt implements XdrElement {
    private Integer discriminant;
    private ContractCodeEntryV1 v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          v1.encode(stream);
          break;
      }
    }

    public static ContractCodeEntryExt decode(XdrDataInputStream stream) throws IOException {
      ContractCodeEntryExt decodedContractCodeEntryExt = new ContractCodeEntryExt();
      Integer discriminant = stream.readInt();
      decodedContractCodeEntryExt.setDiscriminant(discriminant);
      switch (decodedContractCodeEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedContractCodeEntryExt.v1 = ContractCodeEntryV1.decode(stream);
          break;
      }
      return decodedContractCodeEntryExt;
    }

    public static ContractCodeEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static ContractCodeEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    /**
     * ContractCodeEntryV1's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *             {
     *                 ExtensionPoint ext;
     *                 ContractCodeCostInputs costInputs;
     *             }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class ContractCodeEntryV1 implements XdrElement {
      private ExtensionPoint ext;
      private ContractCodeCostInputs costInputs;

      public void encode(XdrDataOutputStream stream) throws IOException {
        ext.encode(stream);
        costInputs.encode(stream);
      }

      public static ContractCodeEntryV1 decode(XdrDataInputStream stream) throws IOException {
        ContractCodeEntryV1 decodedContractCodeEntryV1 = new ContractCodeEntryV1();
        decodedContractCodeEntryV1.ext = ExtensionPoint.decode(stream);
        decodedContractCodeEntryV1.costInputs = ContractCodeCostInputs.decode(stream);
        return decodedContractCodeEntryV1;
      }

      public static ContractCodeEntryV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static ContractCodeEntryV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }
    }
  }
}
