// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCEnvMetaEntry's original definition in the XDR file is:
 *
 * <pre>
 * union SCEnvMetaEntry switch (SCEnvMetaKind kind)
 * {
 * case SC_ENV_META_KIND_INTERFACE_VERSION:
 *     struct {
 *         uint32 protocol;
 *         uint32 preRelease;
 *     } interfaceVersion;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCEnvMetaEntry implements XdrElement {
  private SCEnvMetaKind discriminant;
  private SCEnvMetaEntryInterfaceVersion interfaceVersion;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SC_ENV_META_KIND_INTERFACE_VERSION:
        interfaceVersion.encode(stream);
        break;
    }
  }

  public static SCEnvMetaEntry decode(XdrDataInputStream stream) throws IOException {
    SCEnvMetaEntry decodedSCEnvMetaEntry = new SCEnvMetaEntry();
    SCEnvMetaKind discriminant = SCEnvMetaKind.decode(stream);
    decodedSCEnvMetaEntry.setDiscriminant(discriminant);
    switch (decodedSCEnvMetaEntry.getDiscriminant()) {
      case SC_ENV_META_KIND_INTERFACE_VERSION:
        decodedSCEnvMetaEntry.interfaceVersion = SCEnvMetaEntryInterfaceVersion.decode(stream);
        break;
    }
    return decodedSCEnvMetaEntry;
  }

  public static SCEnvMetaEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCEnvMetaEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * SCEnvMetaEntryInterfaceVersion's original definition in the XDR file is:
   *
   * <pre>
   * struct {
   *         uint32 protocol;
   *         uint32 preRelease;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class SCEnvMetaEntryInterfaceVersion implements XdrElement {
    private Uint32 protocol;
    private Uint32 preRelease;

    public void encode(XdrDataOutputStream stream) throws IOException {
      protocol.encode(stream);
      preRelease.encode(stream);
    }

    public static SCEnvMetaEntryInterfaceVersion decode(XdrDataInputStream stream)
        throws IOException {
      SCEnvMetaEntryInterfaceVersion decodedSCEnvMetaEntryInterfaceVersion =
          new SCEnvMetaEntryInterfaceVersion();
      decodedSCEnvMetaEntryInterfaceVersion.protocol = Uint32.decode(stream);
      decodedSCEnvMetaEntryInterfaceVersion.preRelease = Uint32.decode(stream);
      return decodedSCEnvMetaEntryInterfaceVersion;
    }

    public static SCEnvMetaEntryInterfaceVersion fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static SCEnvMetaEntryInterfaceVersion fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
