// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPEnvelope's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPEnvelope
 * {
 *     SCPStatement statement;
 *     Signature signature;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPEnvelope implements XdrElement {
  private SCPStatement statement;
  private Signature signature;

  public void encode(XdrDataOutputStream stream) throws IOException {
    statement.encode(stream);
    signature.encode(stream);
  }

  public static SCPEnvelope decode(XdrDataInputStream stream) throws IOException {
    SCPEnvelope decodedSCPEnvelope = new SCPEnvelope();
    decodedSCPEnvelope.statement = SCPStatement.decode(stream);
    decodedSCPEnvelope.signature = Signature.decode(stream);
    return decodedSCPEnvelope;
  }

  public static SCPEnvelope fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPEnvelope fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
