// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPHistoryEntryV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPHistoryEntryV0
 * {
 *     SCPQuorumSet quorumSets&lt;&gt;; // additional quorum sets used by ledgerMessages
 *     LedgerSCPMessages ledgerMessages;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPHistoryEntryV0 implements XdrElement {
  private SCPQuorumSet[] quorumSets;
  private LedgerSCPMessages ledgerMessages;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int quorumSetsSize = getQuorumSets().length;
    stream.writeInt(quorumSetsSize);
    for (int i = 0; i < quorumSetsSize; i++) {
      quorumSets[i].encode(stream);
    }
    ledgerMessages.encode(stream);
  }

  public static SCPHistoryEntryV0 decode(XdrDataInputStream stream) throws IOException {
    SCPHistoryEntryV0 decodedSCPHistoryEntryV0 = new SCPHistoryEntryV0();
    int quorumSetsSize = stream.readInt();
    decodedSCPHistoryEntryV0.quorumSets = new SCPQuorumSet[quorumSetsSize];
    for (int i = 0; i < quorumSetsSize; i++) {
      decodedSCPHistoryEntryV0.quorumSets[i] = SCPQuorumSet.decode(stream);
    }
    decodedSCPHistoryEntryV0.ledgerMessages = LedgerSCPMessages.decode(stream);
    return decodedSCPHistoryEntryV0;
  }

  public static SCPHistoryEntryV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPHistoryEntryV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
