// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCPQuorumSet's original definition in the XDR file is:
 *
 * <pre>
 * struct SCPQuorumSet
 * {
 *     uint32 threshold;
 *     NodeID validators&lt;&gt;;
 *     SCPQuorumSet innerSets&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCPQuorumSet implements XdrElement {
  private Uint32 threshold;
  private NodeID[] validators;
  private SCPQuorumSet[] innerSets;

  public void encode(XdrDataOutputStream stream) throws IOException {
    threshold.encode(stream);
    int validatorsSize = getValidators().length;
    stream.writeInt(validatorsSize);
    for (int i = 0; i < validatorsSize; i++) {
      validators[i].encode(stream);
    }
    int innerSetsSize = getInnerSets().length;
    stream.writeInt(innerSetsSize);
    for (int i = 0; i < innerSetsSize; i++) {
      innerSets[i].encode(stream);
    }
  }

  public static SCPQuorumSet decode(XdrDataInputStream stream) throws IOException {
    SCPQuorumSet decodedSCPQuorumSet = new SCPQuorumSet();
    decodedSCPQuorumSet.threshold = Uint32.decode(stream);
    int validatorsSize = stream.readInt();
    decodedSCPQuorumSet.validators = new NodeID[validatorsSize];
    for (int i = 0; i < validatorsSize; i++) {
      decodedSCPQuorumSet.validators[i] = NodeID.decode(stream);
    }
    int innerSetsSize = stream.readInt();
    decodedSCPQuorumSet.innerSets = new SCPQuorumSet[innerSetsSize];
    for (int i = 0; i < innerSetsSize; i++) {
      decodedSCPQuorumSet.innerSets[i] = SCPQuorumSet.decode(stream);
    }
    return decodedSCPQuorumSet;
  }

  public static SCPQuorumSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPQuorumSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
