// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * StoredDebugTransactionSet's original definition in the XDR file is:
 *
 * <pre>
 * struct StoredDebugTransactionSet
 * {
 * 	StoredTransactionSet txSet;
 * 	uint32 ledgerSeq;
 * 	StellarValue scpValue;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class StoredDebugTransactionSet implements XdrElement {
  private StoredTransactionSet txSet;
  private Uint32 ledgerSeq;
  private StellarValue scpValue;

  public void encode(XdrDataOutputStream stream) throws IOException {
    txSet.encode(stream);
    ledgerSeq.encode(stream);
    scpValue.encode(stream);
  }

  public static StoredDebugTransactionSet decode(XdrDataInputStream stream) throws IOException {
    StoredDebugTransactionSet decodedStoredDebugTransactionSet = new StoredDebugTransactionSet();
    decodedStoredDebugTransactionSet.txSet = StoredTransactionSet.decode(stream);
    decodedStoredDebugTransactionSet.ledgerSeq = Uint32.decode(stream);
    decodedStoredDebugTransactionSet.scpValue = StellarValue.decode(stream);
    return decodedStoredDebugTransactionSet;
  }

  public static StoredDebugTransactionSet fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static StoredDebugTransactionSet fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
