// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Transaction's original definition in the XDR file is:
 *
 * <pre>
 * struct Transaction
 * {
 *     // account used to run the transaction
 *     MuxedAccount sourceAccount;
 *
 *     // the fee the sourceAccount will pay
 *     uint32 fee;
 *
 *     // sequence number to consume in the account
 *     SequenceNumber seqNum;
 *
 *     // validity conditions
 *     Preconditions cond;
 *
 *     Memo memo;
 *
 *     Operation operations&lt;MAX_OPS_PER_TX&gt;;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         SorobanTransactionData sorobanData;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Transaction implements XdrElement {
  private MuxedAccount sourceAccount;
  private Uint32 fee;
  private SequenceNumber seqNum;
  private Preconditions cond;
  private Memo memo;
  private Operation[] operations;
  private TransactionExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sourceAccount.encode(stream);
    fee.encode(stream);
    seqNum.encode(stream);
    cond.encode(stream);
    memo.encode(stream);
    int operationsSize = getOperations().length;
    stream.writeInt(operationsSize);
    for (int i = 0; i < operationsSize; i++) {
      operations[i].encode(stream);
    }
    ext.encode(stream);
  }

  public static Transaction decode(XdrDataInputStream stream) throws IOException {
    Transaction decodedTransaction = new Transaction();
    decodedTransaction.sourceAccount = MuxedAccount.decode(stream);
    decodedTransaction.fee = Uint32.decode(stream);
    decodedTransaction.seqNum = SequenceNumber.decode(stream);
    decodedTransaction.cond = Preconditions.decode(stream);
    decodedTransaction.memo = Memo.decode(stream);
    int operationsSize = stream.readInt();
    decodedTransaction.operations = new Operation[operationsSize];
    for (int i = 0; i < operationsSize; i++) {
      decodedTransaction.operations[i] = Operation.decode(stream);
    }
    decodedTransaction.ext = TransactionExt.decode(stream);
    return decodedTransaction;
  }

  public static Transaction fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Transaction fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TransactionExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         SorobanTransactionData sorobanData;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TransactionExt implements XdrElement {
    private Integer discriminant;
    private SorobanTransactionData sorobanData;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          sorobanData.encode(stream);
          break;
      }
    }

    public static TransactionExt decode(XdrDataInputStream stream) throws IOException {
      TransactionExt decodedTransactionExt = new TransactionExt();
      Integer discriminant = stream.readInt();
      decodedTransactionExt.setDiscriminant(discriminant);
      switch (decodedTransactionExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedTransactionExt.sorobanData = SorobanTransactionData.decode(stream);
          break;
      }
      return decodedTransactionExt;
    }

    public static TransactionExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TransactionExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
