// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TrustLineEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct TrustLineEntry
 * {
 *     AccountID accountID;  // account this trustline belongs to
 *     TrustLineAsset asset; // type of asset (with issuer)
 *     int64 balance;        // how much of this asset the user has.
 *                           // Asset defines the unit for this;
 *
 *     int64 limit;  // balance cannot be above this
 *     uint32 flags; // see TrustLineFlags
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     case 1:
 *         struct
 *         {
 *             Liabilities liabilities;
 *
 *             union switch (int v)
 *             {
 *             case 0:
 *                 void;
 *             case 2:
 *                 TrustLineEntryExtensionV2 v2;
 *             }
 *             ext;
 *         } v1;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TrustLineEntry implements XdrElement {
  private AccountID accountID;
  private TrustLineAsset asset;
  private Int64 balance;
  private Int64 limit;
  private Uint32 flags;
  private TrustLineEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    accountID.encode(stream);
    asset.encode(stream);
    balance.encode(stream);
    limit.encode(stream);
    flags.encode(stream);
    ext.encode(stream);
  }

  public static TrustLineEntry decode(XdrDataInputStream stream) throws IOException {
    TrustLineEntry decodedTrustLineEntry = new TrustLineEntry();
    decodedTrustLineEntry.accountID = AccountID.decode(stream);
    decodedTrustLineEntry.asset = TrustLineAsset.decode(stream);
    decodedTrustLineEntry.balance = Int64.decode(stream);
    decodedTrustLineEntry.limit = Int64.decode(stream);
    decodedTrustLineEntry.flags = Uint32.decode(stream);
    decodedTrustLineEntry.ext = TrustLineEntryExt.decode(stream);
    return decodedTrustLineEntry;
  }

  public static TrustLineEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TrustLineEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * TrustLineEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     case 1:
   *         struct
   *         {
   *             Liabilities liabilities;
   *
   *             union switch (int v)
   *             {
   *             case 0:
   *                 void;
   *             case 2:
   *                 TrustLineEntryExtensionV2 v2;
   *             }
   *             ext;
   *         } v1;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class TrustLineEntryExt implements XdrElement {
    private Integer discriminant;
    private TrustLineEntryV1 v1;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
        case 1:
          v1.encode(stream);
          break;
      }
    }

    public static TrustLineEntryExt decode(XdrDataInputStream stream) throws IOException {
      TrustLineEntryExt decodedTrustLineEntryExt = new TrustLineEntryExt();
      Integer discriminant = stream.readInt();
      decodedTrustLineEntryExt.setDiscriminant(discriminant);
      switch (decodedTrustLineEntryExt.getDiscriminant()) {
        case 0:
          break;
        case 1:
          decodedTrustLineEntryExt.v1 = TrustLineEntryV1.decode(stream);
          break;
      }
      return decodedTrustLineEntryExt;
    }

    public static TrustLineEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static TrustLineEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }

    /**
     * TrustLineEntryV1's original definition in the XDR file is:
     *
     * <pre>
     * struct
     *         {
     *             Liabilities liabilities;
     *
     *             union switch (int v)
     *             {
     *             case 0:
     *                 void;
     *             case 2:
     *                 TrustLineEntryExtensionV2 v2;
     *             }
     *             ext;
     *         }
     * </pre>
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder(toBuilder = true)
    public static class TrustLineEntryV1 implements XdrElement {
      private Liabilities liabilities;
      private TrustLineEntryV1Ext ext;

      public void encode(XdrDataOutputStream stream) throws IOException {
        liabilities.encode(stream);
        ext.encode(stream);
      }

      public static TrustLineEntryV1 decode(XdrDataInputStream stream) throws IOException {
        TrustLineEntryV1 decodedTrustLineEntryV1 = new TrustLineEntryV1();
        decodedTrustLineEntryV1.liabilities = Liabilities.decode(stream);
        decodedTrustLineEntryV1.ext = TrustLineEntryV1Ext.decode(stream);
        return decodedTrustLineEntryV1;
      }

      public static TrustLineEntryV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return fromXdrByteArray(bytes);
      }

      public static TrustLineEntryV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return decode(xdrDataInputStream);
      }

      /**
       * TrustLineEntryV1Ext's original definition in the XDR file is:
       *
       * <pre>
       * union switch (int v)
       *             {
       *             case 0:
       *                 void;
       *             case 2:
       *                 TrustLineEntryExtensionV2 v2;
       *             }
       * </pre>
       */
      @Data
      @NoArgsConstructor
      @AllArgsConstructor
      @Builder(toBuilder = true)
      public static class TrustLineEntryV1Ext implements XdrElement {
        private Integer discriminant;
        private TrustLineEntryExtensionV2 v2;

        public void encode(XdrDataOutputStream stream) throws IOException {
          stream.writeInt(discriminant);
          switch (discriminant) {
            case 0:
              break;
            case 2:
              v2.encode(stream);
              break;
          }
        }

        public static TrustLineEntryV1Ext decode(XdrDataInputStream stream) throws IOException {
          TrustLineEntryV1Ext decodedTrustLineEntryV1Ext = new TrustLineEntryV1Ext();
          Integer discriminant = stream.readInt();
          decodedTrustLineEntryV1Ext.setDiscriminant(discriminant);
          switch (decodedTrustLineEntryV1Ext.getDiscriminant()) {
            case 0:
              break;
            case 2:
              decodedTrustLineEntryV1Ext.v2 = TrustLineEntryExtensionV2.decode(stream);
              break;
          }
          return decodedTrustLineEntryV1Ext;
        }

        public static TrustLineEntryV1Ext fromXdrBase64(String xdr) throws IOException {
          byte[] bytes = Base64Factory.getInstance().decode(xdr);
          return fromXdrByteArray(bytes);
        }

        public static TrustLineEntryV1Ext fromXdrByteArray(byte[] xdr) throws IOException {
          ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
          XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
          return decode(xdrDataInputStream);
        }
      }
    }
  }
}
