// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * TrustLineFlags's original definition in the XDR file is:
 *
 * <pre>
 * enum TrustLineFlags
 * {
 *     // issuer has authorized account to perform transactions with its credit
 *     AUTHORIZED_FLAG = 1,
 *     // issuer has authorized account to maintain and reduce liabilities for its
 *     // credit
 *     AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG = 2,
 *     // issuer has specified that it may clawback its credit, and that claimable
 *     // balances created with its credit may also be clawed back
 *     TRUSTLINE_CLAWBACK_ENABLED_FLAG = 4
 * };
 * </pre>
 */
public enum TrustLineFlags implements XdrElement {
  AUTHORIZED_FLAG(1),
  AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG(2),
  TRUSTLINE_CLAWBACK_ENABLED_FLAG(4);

  private final int value;

  TrustLineFlags(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static TrustLineFlags decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 1:
        return AUTHORIZED_FLAG;
      case 2:
        return AUTHORIZED_TO_MAINTAIN_LIABILITIES_FLAG;
      case 4:
        return TRUSTLINE_CLAWBACK_ENABLED_FLAG;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static TrustLineFlags fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TrustLineFlags fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
