/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum12;
import org.stellar.sdk.AssetTypeCreditAlphaNum4;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.AssetType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.PoolID;

public class TrustLineAsset {
    @NonNull
    private final AssetType assetType;
    @Nullable
    private final Asset asset;
    @Nullable
    private final String liquidityPoolId;

    public TrustLineAsset(@NonNull Asset asset) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.assetType = asset.getType();
        this.asset = asset;
        this.liquidityPoolId = null;
    }

    public TrustLineAsset(@NonNull String liquidityPoolId) {
        if (liquidityPoolId == null) {
            throw new NullPointerException("liquidityPoolId is marked non-null but is null");
        }
        this.assetType = AssetType.ASSET_TYPE_POOL_SHARE;
        this.asset = null;
        this.liquidityPoolId = liquidityPoolId.toLowerCase();
    }

    public org.stellar.sdk.xdr.TrustLineAsset toXdr() {
        org.stellar.sdk.xdr.TrustLineAsset xdr = new org.stellar.sdk.xdr.TrustLineAsset();
        if (this.asset != null) {
            org.stellar.sdk.xdr.Asset assetXdr = this.asset.toXdr();
            xdr.setDiscriminant(assetXdr.getDiscriminant());
            xdr.setAlphaNum4(assetXdr.getAlphaNum4());
            xdr.setAlphaNum12(assetXdr.getAlphaNum12());
        }
        if (this.liquidityPoolId != null) {
            xdr.setDiscriminant(AssetType.ASSET_TYPE_POOL_SHARE);
            xdr.setLiquidityPoolID(new PoolID(new Hash(Util.hexToBytes(this.liquidityPoolId))));
        }
        return xdr;
    }

    public static TrustLineAsset fromXdr(org.stellar.sdk.xdr.TrustLineAsset trustLineAsset) {
        switch (trustLineAsset.getDiscriminant()) {
            case ASSET_TYPE_NATIVE: {
                return new TrustLineAsset(new AssetTypeNative());
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                return new TrustLineAsset(AssetTypeCreditAlphaNum4.fromXdr(trustLineAsset.getAlphaNum4()));
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                return new TrustLineAsset(AssetTypeCreditAlphaNum12.fromXdr(trustLineAsset.getAlphaNum12()));
            }
            case ASSET_TYPE_POOL_SHARE: {
                return new TrustLineAsset(Util.bytesToHex(trustLineAsset.getLiquidityPoolID().getPoolID().getHash()).toLowerCase());
            }
        }
        throw new IllegalArgumentException("Unknown asset type " + trustLineAsset.getDiscriminant());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustLineAsset)) {
            return false;
        }
        TrustLineAsset other = (TrustLineAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetType this$assetType = this.getAssetType();
        AssetType other$assetType = other.getAssetType();
        if (this$assetType == null ? other$assetType != null : !this$assetType.equals(other$assetType)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        String this$liquidityPoolId = this.getLiquidityPoolId();
        String other$liquidityPoolId = other.getLiquidityPoolId();
        return !(this$liquidityPoolId == null ? other$liquidityPoolId != null : !this$liquidityPoolId.equals(other$liquidityPoolId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TrustLineAsset;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetType $assetType = this.getAssetType();
        result = result * 59 + ($assetType == null ? 43 : $assetType.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        String $liquidityPoolId = this.getLiquidityPoolId();
        result = result * 59 + ($liquidityPoolId == null ? 43 : $liquidityPoolId.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public AssetType getAssetType() {
        return this.assetType;
    }

    @Nullable
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Nullable
    @Generated
    public String getLiquidityPoolId() {
        return this.liquidityPoolId;
    }
}

