/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.contract;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Address;
import org.stellar.sdk.Auth;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.SorobanDataBuilder;
import org.stellar.sdk.SorobanServer;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.Transaction;
import org.stellar.sdk.TransactionBuilder;
import org.stellar.sdk.TransactionBuilderAccount;
import org.stellar.sdk.TransactionPreconditions;
import org.stellar.sdk.contract.exception.ExpiredStateException;
import org.stellar.sdk.contract.exception.NeedsMoreSignaturesException;
import org.stellar.sdk.contract.exception.NoSignatureNeededException;
import org.stellar.sdk.contract.exception.NotYetSimulatedException;
import org.stellar.sdk.contract.exception.RestorationFailureException;
import org.stellar.sdk.contract.exception.SendTransactionFailedException;
import org.stellar.sdk.contract.exception.SimulationFailedException;
import org.stellar.sdk.contract.exception.TransactionFailedException;
import org.stellar.sdk.contract.exception.TransactionStillPendingException;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.operations.InvokeHostFunctionOperation;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.operations.RestoreFootprintOperation;
import org.stellar.sdk.responses.sorobanrpc.GetTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SendTransactionResponse;
import org.stellar.sdk.responses.sorobanrpc.SimulateTransactionResponse;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SCValType;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanCredentialsType;
import org.stellar.sdk.xdr.SorobanTransactionData;
import org.stellar.sdk.xdr.TransactionMeta;

public class AssembledTransaction<T> {
    private final SorobanServer server;
    private final int submitTimeout;
    private final KeyPair transactionSigner;
    private final Function<SCVal, T> parseResultXdrFn;
    private final TransactionBuilder transactionBuilder;
    private Transaction builtTransaction;
    private SimulateTransactionResponse simulation;
    private SimulateTransactionResponse.SimulateHostFunctionResult simulationResult;
    private SorobanTransactionData simulationTransactionData;
    private SendTransactionResponse sendTransactionResponse;
    private GetTransactionResponse getTransactionResponse;

    public AssembledTransaction(TransactionBuilder transactionBuilder, SorobanServer server, @Nullable KeyPair transactionSigner, @Nullable Function<SCVal, T> parseResultXdrFn, int submitTimeout) {
        this.server = server;
        this.submitTimeout = submitTimeout;
        this.transactionSigner = transactionSigner;
        this.parseResultXdrFn = parseResultXdrFn;
        this.transactionBuilder = transactionBuilder;
    }

    public AssembledTransaction<T> simulate(boolean restore) {
        this.simulationResult = null;
        this.simulationTransactionData = null;
        TransactionBuilderAccount source2 = this.server.getAccount(this.transactionBuilder.getSourceAccount().getAccountId());
        this.transactionBuilder.getSourceAccount().setSequenceNumber(source2.getSequenceNumber());
        Transaction builtTx = this.transactionBuilder.build();
        this.simulation = this.server.simulateTransaction(builtTx);
        if (restore && this.simulation.getRestorePreamble() != null && !this.isReadCall()) {
            try {
                this.restoreFootprint();
            }
            catch (SendTransactionFailedException | SimulationFailedException | TransactionFailedException | TransactionStillPendingException e) {
                throw new RestorationFailureException("Failed to restore contract data.", this);
            }
            return this.simulate(false);
        }
        if (this.simulation.getError() != null) {
            throw new SimulationFailedException("Transaction simulation failed: " + this.simulation.getError(), this);
        }
        this.builtTransaction = SorobanServer.assembleTransaction(builtTx, this.simulation);
        return this;
    }

    public T signAndSubmit(@Nullable KeyPair transactionSigner, boolean force) {
        this.sign(transactionSigner, force);
        return this.submit();
    }

    public AssembledTransaction<T> sign(@Nullable KeyPair transactionSigner, boolean force) {
        KeyPair signer;
        if (this.builtTransaction == null) {
            throw new NotYetSimulatedException("Transaction has not yet been simulated.", this);
        }
        if (!force && this.isReadCall()) {
            throw new NoSignatureNeededException("This is a read call. It requires no signature or submitting. Set force=true to sign and submit anyway.", this);
        }
        if (this.simulation != null && this.simulation.getRestorePreamble() != null) {
            throw new ExpiredStateException("You need to restore contract state before you can invoke this method. You can set `restore` to true in order to automatically restore the contract state when needed.", this);
        }
        KeyPair keyPair = signer = transactionSigner != null ? transactionSigner : this.transactionSigner;
        if (signer == null) {
            throw new IllegalArgumentException("You must provide a signTransactionFunc to sign the transaction, either here or in the constructor.");
        }
        Set<String> sigsNeeded = this.needsNonInvokerSigningBy(false);
        sigsNeeded.removeIf(s -> s.startsWith("C"));
        if (!sigsNeeded.isEmpty()) {
            throw new NeedsMoreSignaturesException("Transaction requires signatures from " + sigsNeeded + ". See `needsNonInvokerSigningBy` for details.", this);
        }
        this.builtTransaction.sign(signer);
        return this;
    }

    public AssembledTransaction<T> signAuthEntries(KeyPair authEntriesSigner) {
        return this.signAuthEntries(authEntriesSigner, null);
    }

    public AssembledTransaction<T> signAuthEntries(KeyPair authEntriesSigner, @Nullable Long validUntilLedgerSequence) {
        Operation op;
        if (this.builtTransaction == null) {
            throw new NotYetSimulatedException("Transaction has not yet been simulated.", this);
        }
        if (validUntilLedgerSequence == null) {
            validUntilLedgerSequence = (long)this.server.getLatestLedger().getSequence().intValue() + 100L;
        }
        if (!((op = this.builtTransaction.getOperations()[0]) instanceof InvokeHostFunctionOperation)) {
            throw new IllegalStateException("Expected InvokeHostFunction operation");
        }
        InvokeHostFunctionOperation invokeHostFunctionOp = (InvokeHostFunctionOperation)op;
        for (int i = 0; i < invokeHostFunctionOp.getAuth().size(); ++i) {
            SorobanAuthorizationEntry e = invokeHostFunctionOp.getAuth().get(i);
            if (SorobanCredentialsType.SOROBAN_CREDENTIALS_SOURCE_ACCOUNT.equals(e.getCredentials().getDiscriminant())) continue;
            if (e.getCredentials().getAddress() == null) {
                throw new IllegalStateException("Expected address in credentials");
            }
            if (!Address.fromSCAddress(e.getCredentials().getAddress().getAddress()).toString().equals(authEntriesSigner.getAccountId())) continue;
            invokeHostFunctionOp.getAuth().set(i, Auth.authorizeEntry(e, authEntriesSigner, validUntilLedgerSequence, this.builtTransaction.getNetwork()));
        }
        return this;
    }

    public Set<String> needsNonInvokerSigningBy(boolean includeAlreadySigned) {
        if (this.builtTransaction == null) {
            throw new NotYetSimulatedException("Transaction has not yet been simulated.", this);
        }
        Operation op = this.builtTransaction.getOperations()[0];
        if (!(op instanceof InvokeHostFunctionOperation)) {
            return new HashSet<String>();
        }
        InvokeHostFunctionOperation invokeHostFunctionOp = (InvokeHostFunctionOperation)op;
        return invokeHostFunctionOp.getAuth().stream().filter(entry -> entry.getCredentials().getDiscriminant() == SorobanCredentialsType.SOROBAN_CREDENTIALS_ADDRESS).filter(entry -> includeAlreadySigned || entry.getCredentials().getAddress().getSignature().getDiscriminant() == SCValType.SCV_VOID).map(entry -> Address.fromSCAddress(entry.getCredentials().getAddress().getAddress()).toString()).collect(Collectors.toSet());
    }

    public T result() throws NotYetSimulatedException {
        SCVal rawResult;
        SimulationData simulationData = this.simulationData();
        try {
            rawResult = SCVal.fromXdrBase64(simulationData.result.getXdr());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert simulation result to SCVal", e);
        }
        if (this.parseResultXdrFn != null) {
            return this.parseResultXdrFn.apply(rawResult);
        }
        SCVal result = rawResult;
        return (T)result;
    }

    public boolean isReadCall() {
        SimulationData simulationData = this.simulationData();
        List<String> auths = simulationData.result.getAuth();
        LedgerKey[] writes = simulationData.transactionData.getResources().getFootprint().getReadWrite();
        return auths.isEmpty() && writes.length == 0;
    }

    public String toEnvelopeXdrBase64() {
        return this.builtTransaction.toEnvelopeXdrBase64();
    }

    public void restoreFootprint() {
        if (this.transactionSigner == null) {
            throw new IllegalArgumentException("For automatic restore to work you must provide a transactionSigner when initializing AssembledTransaction.");
        }
        TransactionBuilder restoreTx = new TransactionBuilder(this.transactionBuilder.getSourceAccount(), this.transactionBuilder.getNetwork()).setBaseFee(this.transactionBuilder.getBaseFee()).addOperation(RestoreFootprintOperation.builder().build()).setSorobanData(new SorobanDataBuilder(this.simulation.getRestorePreamble().getTransactionData()).build()).addPreconditions(TransactionPreconditions.builder().timeBounds(new TimeBounds(0L, 0L)).build());
        AssembledTransaction<T> restoreAssembled = new AssembledTransaction<T>(restoreTx, this.server, this.transactionSigner, null, this.submitTimeout);
        super.submitInternal();
    }

    public T submit() {
        TransactionMeta transactionMeta;
        GetTransactionResponse response = this.submitInternal();
        try {
            transactionMeta = TransactionMeta.fromXdrBase64(response.getResultMetaXdr());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert transaction meta to TransactionMeta", e);
        }
        SCVal resultVal = transactionMeta.getV3().getSorobanMeta().getReturnValue();
        return (T)(this.parseResultXdrFn != null ? this.parseResultXdrFn.apply(resultVal) : resultVal);
    }

    private SimulationData simulationData() {
        if (this.simulationResult != null && this.simulationTransactionData != null) {
            return new SimulationData(this.simulationResult, this.simulationTransactionData);
        }
        if (this.simulation == null) {
            throw new NotYetSimulatedException("Transaction has not yet been simulated.", this);
        }
        this.simulationResult = this.simulation.getResults().get(0);
        try {
            this.simulationTransactionData = SorobanTransactionData.fromXdrBase64(this.simulation.getTransactionData());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert transaction data to SorobanTransactionData", e);
        }
        return new SimulationData(this.simulationResult, this.simulationTransactionData);
    }

    private GetTransactionResponse submitInternal() {
        if (this.builtTransaction == null) {
            throw new NotYetSimulatedException("Transaction has not yet been simulated.", this);
        }
        if (this.sendTransactionResponse == null) {
            this.sendTransactionResponse = this.server.sendTransaction(this.builtTransaction);
            if (this.sendTransactionResponse.getStatus() != SendTransactionResponse.SendTransactionStatus.PENDING) {
                throw new SendTransactionFailedException("Sending the transaction to the network failed!", this);
            }
        }
        String txHash = this.sendTransactionResponse.getHash();
        List<GetTransactionResponse> attempts = AssembledTransaction.withExponentialBackoff(() -> this.server.getTransaction(txHash), resp -> resp.getStatus() == GetTransactionResponse.GetTransactionStatus.NOT_FOUND, this.submitTimeout);
        this.getTransactionResponse = attempts.get(attempts.size() - 1);
        if (this.getTransactionResponse.getStatus() == GetTransactionResponse.GetTransactionStatus.SUCCESS) {
            return this.getTransactionResponse;
        }
        if (this.getTransactionResponse.getStatus() == GetTransactionResponse.GetTransactionStatus.NOT_FOUND) {
            throw new TransactionStillPendingException("Waited " + this.submitTimeout + " seconds for transaction to complete, but it did not. Returning anyway. You can call result() to await the result later or check the status of the transaction manually.", this);
        }
        if (this.getTransactionResponse.getStatus() == GetTransactionResponse.GetTransactionStatus.FAILED) {
            throw new TransactionFailedException("Transaction failed.", this);
        }
        throw new IllegalStateException("Unexpected transaction status.");
    }

    private static <T> List<T> withExponentialBackoff(Supplier<T> fn, Predicate<T> keepWaitingIf, long timeout2) {
        ArrayList<T> attempts = new ArrayList<T>();
        attempts.add(fn.get());
        if (!keepWaitingIf.test(attempts.get(0))) {
            return attempts;
        }
        long waitUntil = System.currentTimeMillis() + timeout2 * 1000L;
        long waitTime = 1000L;
        long maxWaitTime = 60000L;
        while (System.currentTimeMillis() < waitUntil && keepWaitingIf.test(attempts.get(attempts.size() - 1))) {
            try {
                CompletableFuture<T> future = CompletableFuture.supplyAsync(fn);
                future.get(waitTime, TimeUnit.MILLISECONDS);
                attempts.add(future.getNow(null));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UnexpectedException("Exponential backoff interrupted", e);
            }
            catch (ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if ((waitTime *= 2L) > maxWaitTime) {
                waitTime = maxWaitTime;
            }
            if (waitUntil - System.currentTimeMillis() >= waitTime) continue;
            waitTime = waitUntil - System.currentTimeMillis();
        }
        return attempts;
    }

    @Generated
    public Transaction getBuiltTransaction() {
        return this.builtTransaction;
    }

    @Generated
    public SimulateTransactionResponse getSimulation() {
        return this.simulation;
    }

    @Generated
    public SendTransactionResponse getSendTransactionResponse() {
        return this.sendTransactionResponse;
    }

    @Generated
    public GetTransactionResponse getGetTransactionResponse() {
        return this.getTransactionResponse;
    }

    private static final class SimulationData {
        private final SimulateTransactionResponse.SimulateHostFunctionResult result;
        private final SorobanTransactionData transactionData;

        @Generated
        public SimulationData(SimulateTransactionResponse.SimulateHostFunctionResult result, SorobanTransactionData transactionData) {
            this.result = result;
            this.transactionData = transactionData;
        }

        @Generated
        public SimulateTransactionResponse.SimulateHostFunctionResult getResult() {
            return this.result;
        }

        @Generated
        public SorobanTransactionData getTransactionData() {
            return this.transactionData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimulationData)) {
                return false;
            }
            SimulationData other = (SimulationData)o;
            SimulateTransactionResponse.SimulateHostFunctionResult this$result = this.getResult();
            SimulateTransactionResponse.SimulateHostFunctionResult other$result = other.getResult();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            SorobanTransactionData this$transactionData = this.getTransactionData();
            SorobanTransactionData other$transactionData = other.getTransactionData();
            return !(this$transactionData == null ? other$transactionData != null : !((Object)this$transactionData).equals(other$transactionData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SimulateTransactionResponse.SimulateHostFunctionResult $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            SorobanTransactionData $transactionData = this.getTransactionData();
            result = result * 59 + ($transactionData == null ? 43 : ((Object)$transactionData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AssembledTransaction.SimulationData(result=" + this.getResult() + ", transactionData=" + this.getTransactionData() + ")";
        }
    }
}

