/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.operations.OperationResponse;

public class OperationsRequestBuilder
extends RequestBuilder {
    protected Set<String> toJoin = new HashSet<String>();

    public OperationsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "operations");
    }

    public OperationResponse operation(HttpUrl uri) {
        TypeToken<OperationResponse> type = new TypeToken<OperationResponse>(){};
        return OperationsRequestBuilder.executeGetRequest(this.httpClient, uri, type);
    }

    public OperationResponse operation(long operationId) {
        this.setSegments("operations", String.valueOf(operationId));
        return this.operation(this.buildUri());
    }

    public OperationsRequestBuilder forAccount(@NonNull String account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.setSegments("accounts", account, "operations");
        return this;
    }

    public OperationsRequestBuilder forClaimableBalance(@NonNull String claimableBalance) {
        if (claimableBalance == null) {
            throw new NullPointerException("claimableBalance is marked non-null but is null");
        }
        this.setSegments("claimable_balances", claimableBalance, "operations");
        return this;
    }

    public OperationsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "operations");
        return this;
    }

    public OperationsRequestBuilder forTransaction(@NonNull String transactionId) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId is marked non-null but is null");
        }
        this.setSegments("transactions", transactionId, "operations");
        return this;
    }

    public OperationsRequestBuilder forLiquidityPool(String liquidityPoolId) {
        this.setSegments("liquidity_pools", liquidityPoolId, "operations");
        return this;
    }

    public OperationsRequestBuilder includeFailed(boolean value) {
        this.uriBuilder.setQueryParameter("include_failed", String.valueOf(value));
        return this;
    }

    public OperationsRequestBuilder includeTransactions(boolean include) {
        this.updateToJoin("transactions", include);
        return this;
    }

    protected void updateToJoin(String value, boolean include) {
        if (include) {
            this.toJoin.add(value);
        } else {
            this.toJoin.remove(value);
        }
        if (this.toJoin.isEmpty()) {
            this.uriBuilder.removeAllQueryParameters("join");
        } else {
            this.uriBuilder.setQueryParameter("join", String.join((CharSequence)",", this.toJoin));
        }
    }

    public static Page<OperationResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<OperationResponse>> type = new TypeToken<Page<OperationResponse>>(){};
        return OperationsRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<OperationResponse> stream(EventListener<OperationResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, OperationResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<OperationResponse> stream(EventListener<OperationResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<OperationResponse> execute() {
        return OperationsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public OperationsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public OperationsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public OperationsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

