/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum AssetType implements XdrElement
{
    ASSET_TYPE_NATIVE(0),
    ASSET_TYPE_CREDIT_ALPHANUM4(1),
    ASSET_TYPE_CREDIT_ALPHANUM12(2),
    ASSET_TYPE_POOL_SHARE(3);

    private final int value;

    private AssetType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AssetType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return ASSET_TYPE_NATIVE;
            }
            case 1: {
                return ASSET_TYPE_CREDIT_ALPHANUM4;
            }
            case 2: {
                return ASSET_TYPE_CREDIT_ALPHANUM12;
            }
            case 3: {
                return ASSET_TYPE_POOL_SHARE;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static AssetType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AssetType.fromXdrByteArray(bytes);
    }

    public static AssetType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AssetType.decode(xdrDataInputStream);
    }
}

