/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AuthCert;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class Hello
implements XdrElement {
    private Uint32 ledgerVersion;
    private Uint32 overlayVersion;
    private Uint32 overlayMinVersion;
    private Hash networkID;
    private XdrString versionStr;
    private Integer listeningPort;
    private NodeID peerID;
    private AuthCert cert;
    private Uint256 nonce;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ledgerVersion.encode(stream);
        this.overlayVersion.encode(stream);
        this.overlayMinVersion.encode(stream);
        this.networkID.encode(stream);
        this.versionStr.encode(stream);
        stream.writeInt(this.listeningPort);
        this.peerID.encode(stream);
        this.cert.encode(stream);
        this.nonce.encode(stream);
    }

    public static Hello decode(XdrDataInputStream stream) throws IOException {
        Hello decodedHello = new Hello();
        decodedHello.ledgerVersion = Uint32.decode(stream);
        decodedHello.overlayVersion = Uint32.decode(stream);
        decodedHello.overlayMinVersion = Uint32.decode(stream);
        decodedHello.networkID = Hash.decode(stream);
        decodedHello.versionStr = XdrString.decode(stream, 100);
        decodedHello.listeningPort = stream.readInt();
        decodedHello.peerID = NodeID.decode(stream);
        decodedHello.cert = AuthCert.decode(stream);
        decodedHello.nonce = Uint256.decode(stream);
        return decodedHello;
    }

    public static Hello fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Hello.fromXdrByteArray(bytes);
    }

    public static Hello fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Hello.decode(xdrDataInputStream);
    }

    @Generated
    public static HelloBuilder builder() {
        return new HelloBuilder();
    }

    @Generated
    public HelloBuilder toBuilder() {
        return new HelloBuilder().ledgerVersion(this.ledgerVersion).overlayVersion(this.overlayVersion).overlayMinVersion(this.overlayMinVersion).networkID(this.networkID).versionStr(this.versionStr).listeningPort(this.listeningPort).peerID(this.peerID).cert(this.cert).nonce(this.nonce);
    }

    @Generated
    public Uint32 getLedgerVersion() {
        return this.ledgerVersion;
    }

    @Generated
    public Uint32 getOverlayVersion() {
        return this.overlayVersion;
    }

    @Generated
    public Uint32 getOverlayMinVersion() {
        return this.overlayMinVersion;
    }

    @Generated
    public Hash getNetworkID() {
        return this.networkID;
    }

    @Generated
    public XdrString getVersionStr() {
        return this.versionStr;
    }

    @Generated
    public Integer getListeningPort() {
        return this.listeningPort;
    }

    @Generated
    public NodeID getPeerID() {
        return this.peerID;
    }

    @Generated
    public AuthCert getCert() {
        return this.cert;
    }

    @Generated
    public Uint256 getNonce() {
        return this.nonce;
    }

    @Generated
    public void setLedgerVersion(Uint32 ledgerVersion) {
        this.ledgerVersion = ledgerVersion;
    }

    @Generated
    public void setOverlayVersion(Uint32 overlayVersion) {
        this.overlayVersion = overlayVersion;
    }

    @Generated
    public void setOverlayMinVersion(Uint32 overlayMinVersion) {
        this.overlayMinVersion = overlayMinVersion;
    }

    @Generated
    public void setNetworkID(Hash networkID) {
        this.networkID = networkID;
    }

    @Generated
    public void setVersionStr(XdrString versionStr) {
        this.versionStr = versionStr;
    }

    @Generated
    public void setListeningPort(Integer listeningPort) {
        this.listeningPort = listeningPort;
    }

    @Generated
    public void setPeerID(NodeID peerID) {
        this.peerID = peerID;
    }

    @Generated
    public void setCert(AuthCert cert) {
        this.cert = cert;
    }

    @Generated
    public void setNonce(Uint256 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hello)) {
            return false;
        }
        Hello other = (Hello)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$listeningPort = this.getListeningPort();
        Integer other$listeningPort = other.getListeningPort();
        if (this$listeningPort == null ? other$listeningPort != null : !((Object)this$listeningPort).equals(other$listeningPort)) {
            return false;
        }
        Uint32 this$ledgerVersion = this.getLedgerVersion();
        Uint32 other$ledgerVersion = other.getLedgerVersion();
        if (this$ledgerVersion == null ? other$ledgerVersion != null : !((Object)this$ledgerVersion).equals(other$ledgerVersion)) {
            return false;
        }
        Uint32 this$overlayVersion = this.getOverlayVersion();
        Uint32 other$overlayVersion = other.getOverlayVersion();
        if (this$overlayVersion == null ? other$overlayVersion != null : !((Object)this$overlayVersion).equals(other$overlayVersion)) {
            return false;
        }
        Uint32 this$overlayMinVersion = this.getOverlayMinVersion();
        Uint32 other$overlayMinVersion = other.getOverlayMinVersion();
        if (this$overlayMinVersion == null ? other$overlayMinVersion != null : !((Object)this$overlayMinVersion).equals(other$overlayMinVersion)) {
            return false;
        }
        Hash this$networkID = this.getNetworkID();
        Hash other$networkID = other.getNetworkID();
        if (this$networkID == null ? other$networkID != null : !((Object)this$networkID).equals(other$networkID)) {
            return false;
        }
        XdrString this$versionStr = this.getVersionStr();
        XdrString other$versionStr = other.getVersionStr();
        if (this$versionStr == null ? other$versionStr != null : !((Object)this$versionStr).equals(other$versionStr)) {
            return false;
        }
        NodeID this$peerID = this.getPeerID();
        NodeID other$peerID = other.getPeerID();
        if (this$peerID == null ? other$peerID != null : !((Object)this$peerID).equals(other$peerID)) {
            return false;
        }
        AuthCert this$cert = this.getCert();
        AuthCert other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !((Object)this$cert).equals(other$cert)) {
            return false;
        }
        Uint256 this$nonce = this.getNonce();
        Uint256 other$nonce = other.getNonce();
        return !(this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Hello;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $listeningPort = this.getListeningPort();
        result = result * 59 + ($listeningPort == null ? 43 : ((Object)$listeningPort).hashCode());
        Uint32 $ledgerVersion = this.getLedgerVersion();
        result = result * 59 + ($ledgerVersion == null ? 43 : ((Object)$ledgerVersion).hashCode());
        Uint32 $overlayVersion = this.getOverlayVersion();
        result = result * 59 + ($overlayVersion == null ? 43 : ((Object)$overlayVersion).hashCode());
        Uint32 $overlayMinVersion = this.getOverlayMinVersion();
        result = result * 59 + ($overlayMinVersion == null ? 43 : ((Object)$overlayMinVersion).hashCode());
        Hash $networkID = this.getNetworkID();
        result = result * 59 + ($networkID == null ? 43 : ((Object)$networkID).hashCode());
        XdrString $versionStr = this.getVersionStr();
        result = result * 59 + ($versionStr == null ? 43 : ((Object)$versionStr).hashCode());
        NodeID $peerID = this.getPeerID();
        result = result * 59 + ($peerID == null ? 43 : ((Object)$peerID).hashCode());
        AuthCert $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : ((Object)$cert).hashCode());
        Uint256 $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Hello(ledgerVersion=" + this.getLedgerVersion() + ", overlayVersion=" + this.getOverlayVersion() + ", overlayMinVersion=" + this.getOverlayMinVersion() + ", networkID=" + this.getNetworkID() + ", versionStr=" + this.getVersionStr() + ", listeningPort=" + this.getListeningPort() + ", peerID=" + this.getPeerID() + ", cert=" + this.getCert() + ", nonce=" + this.getNonce() + ")";
    }

    @Generated
    public Hello() {
    }

    @Generated
    public Hello(Uint32 ledgerVersion, Uint32 overlayVersion, Uint32 overlayMinVersion, Hash networkID, XdrString versionStr, Integer listeningPort, NodeID peerID, AuthCert cert, Uint256 nonce) {
        this.ledgerVersion = ledgerVersion;
        this.overlayVersion = overlayVersion;
        this.overlayMinVersion = overlayMinVersion;
        this.networkID = networkID;
        this.versionStr = versionStr;
        this.listeningPort = listeningPort;
        this.peerID = peerID;
        this.cert = cert;
        this.nonce = nonce;
    }

    @Generated
    public static class HelloBuilder {
        @Generated
        private Uint32 ledgerVersion;
        @Generated
        private Uint32 overlayVersion;
        @Generated
        private Uint32 overlayMinVersion;
        @Generated
        private Hash networkID;
        @Generated
        private XdrString versionStr;
        @Generated
        private Integer listeningPort;
        @Generated
        private NodeID peerID;
        @Generated
        private AuthCert cert;
        @Generated
        private Uint256 nonce;

        @Generated
        HelloBuilder() {
        }

        @Generated
        public HelloBuilder ledgerVersion(Uint32 ledgerVersion) {
            this.ledgerVersion = ledgerVersion;
            return this;
        }

        @Generated
        public HelloBuilder overlayVersion(Uint32 overlayVersion) {
            this.overlayVersion = overlayVersion;
            return this;
        }

        @Generated
        public HelloBuilder overlayMinVersion(Uint32 overlayMinVersion) {
            this.overlayMinVersion = overlayMinVersion;
            return this;
        }

        @Generated
        public HelloBuilder networkID(Hash networkID) {
            this.networkID = networkID;
            return this;
        }

        @Generated
        public HelloBuilder versionStr(XdrString versionStr) {
            this.versionStr = versionStr;
            return this;
        }

        @Generated
        public HelloBuilder listeningPort(Integer listeningPort) {
            this.listeningPort = listeningPort;
            return this;
        }

        @Generated
        public HelloBuilder peerID(NodeID peerID) {
            this.peerID = peerID;
            return this;
        }

        @Generated
        public HelloBuilder cert(AuthCert cert) {
            this.cert = cert;
            return this;
        }

        @Generated
        public HelloBuilder nonce(Uint256 nonce) {
            this.nonce = nonce;
            return this;
        }

        @Generated
        public Hello build() {
            return new Hello(this.ledgerVersion, this.overlayVersion, this.overlayMinVersion, this.networkID, this.versionStr, this.listeningPort, this.peerID, this.cert, this.nonce);
        }

        @Generated
        public String toString() {
            return "Hello.HelloBuilder(ledgerVersion=" + this.ledgerVersion + ", overlayVersion=" + this.overlayVersion + ", overlayMinVersion=" + this.overlayMinVersion + ", networkID=" + this.networkID + ", versionStr=" + this.versionStr + ", listeningPort=" + this.listeningPort + ", peerID=" + this.peerID + ", cert=" + this.cert + ", nonce=" + this.nonce + ")";
        }
    }
}

