/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PathPaymentStrictReceiveOp
implements XdrElement {
    private Asset sendAsset;
    private Int64 sendMax;
    private MuxedAccount destination;
    private Asset destAsset;
    private Int64 destAmount;
    private Asset[] path;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.sendAsset.encode(stream);
        this.sendMax.encode(stream);
        this.destination.encode(stream);
        this.destAsset.encode(stream);
        this.destAmount.encode(stream);
        int pathSize = this.getPath().length;
        stream.writeInt(pathSize);
        for (int i = 0; i < pathSize; ++i) {
            this.path[i].encode(stream);
        }
    }

    public static PathPaymentStrictReceiveOp decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictReceiveOp decodedPathPaymentStrictReceiveOp = new PathPaymentStrictReceiveOp();
        decodedPathPaymentStrictReceiveOp.sendAsset = Asset.decode(stream);
        decodedPathPaymentStrictReceiveOp.sendMax = Int64.decode(stream);
        decodedPathPaymentStrictReceiveOp.destination = MuxedAccount.decode(stream);
        decodedPathPaymentStrictReceiveOp.destAsset = Asset.decode(stream);
        decodedPathPaymentStrictReceiveOp.destAmount = Int64.decode(stream);
        int pathSize = stream.readInt();
        decodedPathPaymentStrictReceiveOp.path = new Asset[pathSize];
        for (int i = 0; i < pathSize; ++i) {
            decodedPathPaymentStrictReceiveOp.path[i] = Asset.decode(stream);
        }
        return decodedPathPaymentStrictReceiveOp;
    }

    public static PathPaymentStrictReceiveOp fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictReceiveOp.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictReceiveOp fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictReceiveOp.decode(xdrDataInputStream);
    }

    @Generated
    public static PathPaymentStrictReceiveOpBuilder builder() {
        return new PathPaymentStrictReceiveOpBuilder();
    }

    @Generated
    public PathPaymentStrictReceiveOpBuilder toBuilder() {
        return new PathPaymentStrictReceiveOpBuilder().sendAsset(this.sendAsset).sendMax(this.sendMax).destination(this.destination).destAsset(this.destAsset).destAmount(this.destAmount).path(this.path);
    }

    @Generated
    public Asset getSendAsset() {
        return this.sendAsset;
    }

    @Generated
    public Int64 getSendMax() {
        return this.sendMax;
    }

    @Generated
    public MuxedAccount getDestination() {
        return this.destination;
    }

    @Generated
    public Asset getDestAsset() {
        return this.destAsset;
    }

    @Generated
    public Int64 getDestAmount() {
        return this.destAmount;
    }

    @Generated
    public Asset[] getPath() {
        return this.path;
    }

    @Generated
    public void setSendAsset(Asset sendAsset) {
        this.sendAsset = sendAsset;
    }

    @Generated
    public void setSendMax(Int64 sendMax) {
        this.sendMax = sendMax;
    }

    @Generated
    public void setDestination(MuxedAccount destination) {
        this.destination = destination;
    }

    @Generated
    public void setDestAsset(Asset destAsset) {
        this.destAsset = destAsset;
    }

    @Generated
    public void setDestAmount(Int64 destAmount) {
        this.destAmount = destAmount;
    }

    @Generated
    public void setPath(Asset[] path) {
        this.path = path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictReceiveOp)) {
            return false;
        }
        PathPaymentStrictReceiveOp other = (PathPaymentStrictReceiveOp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Asset this$sendAsset = this.getSendAsset();
        Asset other$sendAsset = other.getSendAsset();
        if (this$sendAsset == null ? other$sendAsset != null : !((Object)this$sendAsset).equals(other$sendAsset)) {
            return false;
        }
        Int64 this$sendMax = this.getSendMax();
        Int64 other$sendMax = other.getSendMax();
        if (this$sendMax == null ? other$sendMax != null : !((Object)this$sendMax).equals(other$sendMax)) {
            return false;
        }
        MuxedAccount this$destination = this.getDestination();
        MuxedAccount other$destination = other.getDestination();
        if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
            return false;
        }
        Asset this$destAsset = this.getDestAsset();
        Asset other$destAsset = other.getDestAsset();
        if (this$destAsset == null ? other$destAsset != null : !((Object)this$destAsset).equals(other$destAsset)) {
            return false;
        }
        Int64 this$destAmount = this.getDestAmount();
        Int64 other$destAmount = other.getDestAmount();
        if (this$destAmount == null ? other$destAmount != null : !((Object)this$destAmount).equals(other$destAmount)) {
            return false;
        }
        return Arrays.deepEquals(this.getPath(), other.getPath());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictReceiveOp;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Asset $sendAsset = this.getSendAsset();
        result = result * 59 + ($sendAsset == null ? 43 : ((Object)$sendAsset).hashCode());
        Int64 $sendMax = this.getSendMax();
        result = result * 59 + ($sendMax == null ? 43 : ((Object)$sendMax).hashCode());
        MuxedAccount $destination = this.getDestination();
        result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
        Asset $destAsset = this.getDestAsset();
        result = result * 59 + ($destAsset == null ? 43 : ((Object)$destAsset).hashCode());
        Int64 $destAmount = this.getDestAmount();
        result = result * 59 + ($destAmount == null ? 43 : ((Object)$destAmount).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        return result;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictReceiveOp(sendAsset=" + this.getSendAsset() + ", sendMax=" + this.getSendMax() + ", destination=" + this.getDestination() + ", destAsset=" + this.getDestAsset() + ", destAmount=" + this.getDestAmount() + ", path=" + Arrays.deepToString(this.getPath()) + ")";
    }

    @Generated
    public PathPaymentStrictReceiveOp() {
    }

    @Generated
    public PathPaymentStrictReceiveOp(Asset sendAsset, Int64 sendMax, MuxedAccount destination, Asset destAsset, Int64 destAmount, Asset[] path) {
        this.sendAsset = sendAsset;
        this.sendMax = sendMax;
        this.destination = destination;
        this.destAsset = destAsset;
        this.destAmount = destAmount;
        this.path = path;
    }

    @Generated
    public static class PathPaymentStrictReceiveOpBuilder {
        @Generated
        private Asset sendAsset;
        @Generated
        private Int64 sendMax;
        @Generated
        private MuxedAccount destination;
        @Generated
        private Asset destAsset;
        @Generated
        private Int64 destAmount;
        @Generated
        private Asset[] path;

        @Generated
        PathPaymentStrictReceiveOpBuilder() {
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder sendAsset(Asset sendAsset) {
            this.sendAsset = sendAsset;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder sendMax(Int64 sendMax) {
            this.sendMax = sendMax;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder destination(MuxedAccount destination) {
            this.destination = destination;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder destAsset(Asset destAsset) {
            this.destAsset = destAsset;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder destAmount(Int64 destAmount) {
            this.destAmount = destAmount;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOpBuilder path(Asset[] path) {
            this.path = path;
            return this;
        }

        @Generated
        public PathPaymentStrictReceiveOp build() {
            return new PathPaymentStrictReceiveOp(this.sendAsset, this.sendMax, this.destination, this.destAsset, this.destAmount, this.path);
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictReceiveOp.PathPaymentStrictReceiveOpBuilder(sendAsset=" + this.sendAsset + ", sendMax=" + this.sendMax + ", destination=" + this.destination + ", destAsset=" + this.destAsset + ", destAmount=" + this.destAmount + ", path=" + Arrays.deepToString(this.path) + ")";
        }
    }
}

