/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCErrorCode;
import org.stellar.sdk.xdr.SCErrorType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCError
implements XdrElement {
    private SCErrorType discriminant;
    private Uint32 contractCode;
    private SCErrorCode code;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SCE_CONTRACT: {
                this.contractCode.encode(stream);
                break;
            }
            case SCE_WASM_VM: 
            case SCE_CONTEXT: 
            case SCE_STORAGE: 
            case SCE_OBJECT: 
            case SCE_CRYPTO: 
            case SCE_EVENTS: 
            case SCE_BUDGET: 
            case SCE_VALUE: 
            case SCE_AUTH: {
                this.code.encode(stream);
            }
        }
    }

    public static SCError decode(XdrDataInputStream stream) throws IOException {
        SCError decodedSCError = new SCError();
        SCErrorType discriminant = SCErrorType.decode(stream);
        decodedSCError.setDiscriminant(discriminant);
        switch (decodedSCError.getDiscriminant()) {
            case SCE_CONTRACT: {
                decodedSCError.contractCode = Uint32.decode(stream);
                break;
            }
            case SCE_WASM_VM: 
            case SCE_CONTEXT: 
            case SCE_STORAGE: 
            case SCE_OBJECT: 
            case SCE_CRYPTO: 
            case SCE_EVENTS: 
            case SCE_BUDGET: 
            case SCE_VALUE: 
            case SCE_AUTH: {
                decodedSCError.code = SCErrorCode.decode(stream);
            }
        }
        return decodedSCError;
    }

    public static SCError fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCError.fromXdrByteArray(bytes);
    }

    public static SCError fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCError.decode(xdrDataInputStream);
    }

    @Generated
    public static SCErrorBuilder builder() {
        return new SCErrorBuilder();
    }

    @Generated
    public SCErrorBuilder toBuilder() {
        return new SCErrorBuilder().discriminant(this.discriminant).contractCode(this.contractCode).code(this.code);
    }

    @Generated
    public SCErrorType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Uint32 getContractCode() {
        return this.contractCode;
    }

    @Generated
    public SCErrorCode getCode() {
        return this.code;
    }

    @Generated
    public void setDiscriminant(SCErrorType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setContractCode(Uint32 contractCode) {
        this.contractCode = contractCode;
    }

    @Generated
    public void setCode(SCErrorCode code) {
        this.code = code;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCError)) {
            return false;
        }
        SCError other = (SCError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCErrorType this$discriminant = this.getDiscriminant();
        SCErrorType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Uint32 this$contractCode = this.getContractCode();
        Uint32 other$contractCode = other.getContractCode();
        if (this$contractCode == null ? other$contractCode != null : !((Object)this$contractCode).equals(other$contractCode)) {
            return false;
        }
        SCErrorCode this$code = this.getCode();
        SCErrorCode other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCErrorType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Uint32 $contractCode = this.getContractCode();
        result = result * 59 + ($contractCode == null ? 43 : ((Object)$contractCode).hashCode());
        SCErrorCode $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCError(discriminant=" + this.getDiscriminant() + ", contractCode=" + this.getContractCode() + ", code=" + this.getCode() + ")";
    }

    @Generated
    public SCError() {
    }

    @Generated
    public SCError(SCErrorType discriminant, Uint32 contractCode, SCErrorCode code) {
        this.discriminant = discriminant;
        this.contractCode = contractCode;
        this.code = code;
    }

    @Generated
    public static class SCErrorBuilder {
        @Generated
        private SCErrorType discriminant;
        @Generated
        private Uint32 contractCode;
        @Generated
        private SCErrorCode code;

        @Generated
        SCErrorBuilder() {
        }

        @Generated
        public SCErrorBuilder discriminant(SCErrorType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCErrorBuilder contractCode(Uint32 contractCode) {
            this.contractCode = contractCode;
            return this;
        }

        @Generated
        public SCErrorBuilder code(SCErrorCode code) {
            this.code = code;
            return this;
        }

        @Generated
        public SCError build() {
            return new SCError(this.discriminant, this.contractCode, this.code);
        }

        @Generated
        public String toString() {
            return "SCError.SCErrorBuilder(discriminant=" + this.discriminant + ", contractCode=" + this.contractCode + ", code=" + this.code + ")";
        }
    }
}

