/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SCSpecUDTEnumCaseV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class SCSpecUDTEnumV0
implements XdrElement {
    private XdrString doc;
    private XdrString lib;
    private XdrString name;
    private SCSpecUDTEnumCaseV0[] cases;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.doc.encode(stream);
        this.lib.encode(stream);
        this.name.encode(stream);
        int casesSize = this.getCases().length;
        stream.writeInt(casesSize);
        for (int i = 0; i < casesSize; ++i) {
            this.cases[i].encode(stream);
        }
    }

    public static SCSpecUDTEnumV0 decode(XdrDataInputStream stream) throws IOException {
        SCSpecUDTEnumV0 decodedSCSpecUDTEnumV0 = new SCSpecUDTEnumV0();
        decodedSCSpecUDTEnumV0.doc = XdrString.decode(stream, 1024);
        decodedSCSpecUDTEnumV0.lib = XdrString.decode(stream, 80);
        decodedSCSpecUDTEnumV0.name = XdrString.decode(stream, 60);
        int casesSize = stream.readInt();
        decodedSCSpecUDTEnumV0.cases = new SCSpecUDTEnumCaseV0[casesSize];
        for (int i = 0; i < casesSize; ++i) {
            decodedSCSpecUDTEnumV0.cases[i] = SCSpecUDTEnumCaseV0.decode(stream);
        }
        return decodedSCSpecUDTEnumV0;
    }

    public static SCSpecUDTEnumV0 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecUDTEnumV0.fromXdrByteArray(bytes);
    }

    public static SCSpecUDTEnumV0 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecUDTEnumV0.decode(xdrDataInputStream);
    }

    @Generated
    public static SCSpecUDTEnumV0Builder builder() {
        return new SCSpecUDTEnumV0Builder();
    }

    @Generated
    public SCSpecUDTEnumV0Builder toBuilder() {
        return new SCSpecUDTEnumV0Builder().doc(this.doc).lib(this.lib).name(this.name).cases(this.cases);
    }

    @Generated
    public XdrString getDoc() {
        return this.doc;
    }

    @Generated
    public XdrString getLib() {
        return this.lib;
    }

    @Generated
    public XdrString getName() {
        return this.name;
    }

    @Generated
    public SCSpecUDTEnumCaseV0[] getCases() {
        return this.cases;
    }

    @Generated
    public void setDoc(XdrString doc) {
        this.doc = doc;
    }

    @Generated
    public void setLib(XdrString lib) {
        this.lib = lib;
    }

    @Generated
    public void setName(XdrString name) {
        this.name = name;
    }

    @Generated
    public void setCases(SCSpecUDTEnumCaseV0[] cases) {
        this.cases = cases;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCSpecUDTEnumV0)) {
            return false;
        }
        SCSpecUDTEnumV0 other = (SCSpecUDTEnumV0)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XdrString this$doc = this.getDoc();
        XdrString other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        XdrString this$lib = this.getLib();
        XdrString other$lib = other.getLib();
        if (this$lib == null ? other$lib != null : !((Object)this$lib).equals(other$lib)) {
            return false;
        }
        XdrString this$name = this.getName();
        XdrString other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        return Arrays.deepEquals(this.getCases(), other.getCases());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCSpecUDTEnumV0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XdrString $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        XdrString $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : ((Object)$lib).hashCode());
        XdrString $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCases());
        return result;
    }

    @Generated
    public String toString() {
        return "SCSpecUDTEnumV0(doc=" + this.getDoc() + ", lib=" + this.getLib() + ", name=" + this.getName() + ", cases=" + Arrays.deepToString(this.getCases()) + ")";
    }

    @Generated
    public SCSpecUDTEnumV0() {
    }

    @Generated
    public SCSpecUDTEnumV0(XdrString doc, XdrString lib, XdrString name, SCSpecUDTEnumCaseV0[] cases) {
        this.doc = doc;
        this.lib = lib;
        this.name = name;
        this.cases = cases;
    }

    @Generated
    public static class SCSpecUDTEnumV0Builder {
        @Generated
        private XdrString doc;
        @Generated
        private XdrString lib;
        @Generated
        private XdrString name;
        @Generated
        private SCSpecUDTEnumCaseV0[] cases;

        @Generated
        SCSpecUDTEnumV0Builder() {
        }

        @Generated
        public SCSpecUDTEnumV0Builder doc(XdrString doc) {
            this.doc = doc;
            return this;
        }

        @Generated
        public SCSpecUDTEnumV0Builder lib(XdrString lib) {
            this.lib = lib;
            return this;
        }

        @Generated
        public SCSpecUDTEnumV0Builder name(XdrString name) {
            this.name = name;
            return this;
        }

        @Generated
        public SCSpecUDTEnumV0Builder cases(SCSpecUDTEnumCaseV0[] cases) {
            this.cases = cases;
            return this;
        }

        @Generated
        public SCSpecUDTEnumV0 build() {
            return new SCSpecUDTEnumV0(this.doc, this.lib, this.name, this.cases);
        }

        @Generated
        public String toString() {
            return "SCSpecUDTEnumV0.SCSpecUDTEnumV0Builder(doc=" + this.doc + ", lib=" + this.lib + ", name=" + this.name + ", cases=" + Arrays.deepToString(this.cases) + ")";
        }
    }
}

