/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ShortHashSeed
implements XdrElement {
    private byte[] seed;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int seedSize = this.seed.length;
        stream.write(this.getSeed(), 0, seedSize);
    }

    public static ShortHashSeed decode(XdrDataInputStream stream) throws IOException {
        ShortHashSeed decodedShortHashSeed = new ShortHashSeed();
        int seedSize = 16;
        decodedShortHashSeed.seed = new byte[seedSize];
        stream.read(decodedShortHashSeed.seed, 0, seedSize);
        return decodedShortHashSeed;
    }

    public static ShortHashSeed fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ShortHashSeed.fromXdrByteArray(bytes);
    }

    public static ShortHashSeed fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ShortHashSeed.decode(xdrDataInputStream);
    }

    @Generated
    public static ShortHashSeedBuilder builder() {
        return new ShortHashSeedBuilder();
    }

    @Generated
    public ShortHashSeedBuilder toBuilder() {
        return new ShortHashSeedBuilder().seed(this.seed);
    }

    @Generated
    public byte[] getSeed() {
        return this.seed;
    }

    @Generated
    public void setSeed(byte[] seed) {
        this.seed = seed;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShortHashSeed)) {
            return false;
        }
        ShortHashSeed other = (ShortHashSeed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getSeed(), other.getSeed());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShortHashSeed;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSeed());
        return result;
    }

    @Generated
    public String toString() {
        return "ShortHashSeed(seed=" + Arrays.toString(this.getSeed()) + ")";
    }

    @Generated
    public ShortHashSeed() {
    }

    @Generated
    public ShortHashSeed(byte[] seed) {
        this.seed = seed;
    }

    @Generated
    public static class ShortHashSeedBuilder {
        @Generated
        private byte[] seed;

        @Generated
        ShortHashSeedBuilder() {
        }

        @Generated
        public ShortHashSeedBuilder seed(byte[] seed) {
            this.seed = seed;
            return this;
        }

        @Generated
        public ShortHashSeed build() {
            return new ShortHashSeed(this.seed);
        }

        @Generated
        public String toString() {
            return "ShortHashSeed.ShortHashSeedBuilder(seed=" + Arrays.toString(this.seed) + ")";
        }
    }
}

