/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Signer
implements XdrElement {
    private SignerKey key;
    private Uint32 weight;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.key.encode(stream);
        this.weight.encode(stream);
    }

    public static Signer decode(XdrDataInputStream stream) throws IOException {
        Signer decodedSigner = new Signer();
        decodedSigner.key = SignerKey.decode(stream);
        decodedSigner.weight = Uint32.decode(stream);
        return decodedSigner;
    }

    public static Signer fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Signer.fromXdrByteArray(bytes);
    }

    public static Signer fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Signer.decode(xdrDataInputStream);
    }

    @Generated
    public static SignerBuilder builder() {
        return new SignerBuilder();
    }

    @Generated
    public SignerBuilder toBuilder() {
        return new SignerBuilder().key(this.key).weight(this.weight);
    }

    @Generated
    public SignerKey getKey() {
        return this.key;
    }

    @Generated
    public Uint32 getWeight() {
        return this.weight;
    }

    @Generated
    public void setKey(SignerKey key) {
        this.key = key;
    }

    @Generated
    public void setWeight(Uint32 weight) {
        this.weight = weight;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signer)) {
            return false;
        }
        Signer other = (Signer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SignerKey this$key = this.getKey();
        SignerKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        Uint32 this$weight = this.getWeight();
        Uint32 other$weight = other.getWeight();
        return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Signer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SignerKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        Uint32 $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Signer(key=" + this.getKey() + ", weight=" + this.getWeight() + ")";
    }

    @Generated
    public Signer() {
    }

    @Generated
    public Signer(SignerKey key, Uint32 weight) {
        this.key = key;
        this.weight = weight;
    }

    @Generated
    public static class SignerBuilder {
        @Generated
        private SignerKey key;
        @Generated
        private Uint32 weight;

        @Generated
        SignerBuilder() {
        }

        @Generated
        public SignerBuilder key(SignerKey key) {
            this.key = key;
            return this;
        }

        @Generated
        public SignerBuilder weight(Uint32 weight) {
            this.weight = weight;
            return this;
        }

        @Generated
        public Signer build() {
            return new Signer(this.key, this.weight);
        }

        @Generated
        public String toString() {
            return "Signer.SignerBuilder(key=" + this.key + ", weight=" + this.weight + ")";
        }
    }
}

