/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TTLEntry
implements XdrElement {
    private Hash keyHash;
    private Uint32 liveUntilLedgerSeq;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.keyHash.encode(stream);
        this.liveUntilLedgerSeq.encode(stream);
    }

    public static TTLEntry decode(XdrDataInputStream stream) throws IOException {
        TTLEntry decodedTTLEntry = new TTLEntry();
        decodedTTLEntry.keyHash = Hash.decode(stream);
        decodedTTLEntry.liveUntilLedgerSeq = Uint32.decode(stream);
        return decodedTTLEntry;
    }

    public static TTLEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TTLEntry.fromXdrByteArray(bytes);
    }

    public static TTLEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TTLEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static TTLEntryBuilder builder() {
        return new TTLEntryBuilder();
    }

    @Generated
    public TTLEntryBuilder toBuilder() {
        return new TTLEntryBuilder().keyHash(this.keyHash).liveUntilLedgerSeq(this.liveUntilLedgerSeq);
    }

    @Generated
    public Hash getKeyHash() {
        return this.keyHash;
    }

    @Generated
    public Uint32 getLiveUntilLedgerSeq() {
        return this.liveUntilLedgerSeq;
    }

    @Generated
    public void setKeyHash(Hash keyHash) {
        this.keyHash = keyHash;
    }

    @Generated
    public void setLiveUntilLedgerSeq(Uint32 liveUntilLedgerSeq) {
        this.liveUntilLedgerSeq = liveUntilLedgerSeq;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TTLEntry)) {
            return false;
        }
        TTLEntry other = (TTLEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$keyHash = this.getKeyHash();
        Hash other$keyHash = other.getKeyHash();
        if (this$keyHash == null ? other$keyHash != null : !((Object)this$keyHash).equals(other$keyHash)) {
            return false;
        }
        Uint32 this$liveUntilLedgerSeq = this.getLiveUntilLedgerSeq();
        Uint32 other$liveUntilLedgerSeq = other.getLiveUntilLedgerSeq();
        return !(this$liveUntilLedgerSeq == null ? other$liveUntilLedgerSeq != null : !((Object)this$liveUntilLedgerSeq).equals(other$liveUntilLedgerSeq));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TTLEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $keyHash = this.getKeyHash();
        result = result * 59 + ($keyHash == null ? 43 : ((Object)$keyHash).hashCode());
        Uint32 $liveUntilLedgerSeq = this.getLiveUntilLedgerSeq();
        result = result * 59 + ($liveUntilLedgerSeq == null ? 43 : ((Object)$liveUntilLedgerSeq).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TTLEntry(keyHash=" + this.getKeyHash() + ", liveUntilLedgerSeq=" + this.getLiveUntilLedgerSeq() + ")";
    }

    @Generated
    public TTLEntry() {
    }

    @Generated
    public TTLEntry(Hash keyHash, Uint32 liveUntilLedgerSeq) {
        this.keyHash = keyHash;
        this.liveUntilLedgerSeq = liveUntilLedgerSeq;
    }

    @Generated
    public static class TTLEntryBuilder {
        @Generated
        private Hash keyHash;
        @Generated
        private Uint32 liveUntilLedgerSeq;

        @Generated
        TTLEntryBuilder() {
        }

        @Generated
        public TTLEntryBuilder keyHash(Hash keyHash) {
            this.keyHash = keyHash;
            return this;
        }

        @Generated
        public TTLEntryBuilder liveUntilLedgerSeq(Uint32 liveUntilLedgerSeq) {
            this.liveUntilLedgerSeq = liveUntilLedgerSeq;
            return this;
        }

        @Generated
        public TTLEntry build() {
            return new TTLEntry(this.keyHash, this.liveUntilLedgerSeq);
        }

        @Generated
        public String toString() {
            return "TTLEntry.TTLEntryBuilder(keyHash=" + this.keyHash + ", liveUntilLedgerSeq=" + this.liveUntilLedgerSeq + ")";
        }
    }
}

