/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMetaV2
implements XdrElement {
    private LedgerEntryChanges txChangesBefore;
    private OperationMeta[] operations;
    private LedgerEntryChanges txChangesAfter;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.txChangesBefore.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
        this.txChangesAfter.encode(stream);
    }

    public static TransactionMetaV2 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV2 decodedTransactionMetaV2 = new TransactionMetaV2();
        decodedTransactionMetaV2.txChangesBefore = LedgerEntryChanges.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransactionMetaV2.operations = new OperationMeta[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransactionMetaV2.operations[i] = OperationMeta.decode(stream);
        }
        decodedTransactionMetaV2.txChangesAfter = LedgerEntryChanges.decode(stream);
        return decodedTransactionMetaV2;
    }

    public static TransactionMetaV2 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMetaV2.fromXdrByteArray(bytes);
    }

    public static TransactionMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMetaV2.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionMetaV2Builder builder() {
        return new TransactionMetaV2Builder();
    }

    @Generated
    public TransactionMetaV2Builder toBuilder() {
        return new TransactionMetaV2Builder().txChangesBefore(this.txChangesBefore).operations(this.operations).txChangesAfter(this.txChangesAfter);
    }

    @Generated
    public LedgerEntryChanges getTxChangesBefore() {
        return this.txChangesBefore;
    }

    @Generated
    public OperationMeta[] getOperations() {
        return this.operations;
    }

    @Generated
    public LedgerEntryChanges getTxChangesAfter() {
        return this.txChangesAfter;
    }

    @Generated
    public void setTxChangesBefore(LedgerEntryChanges txChangesBefore) {
        this.txChangesBefore = txChangesBefore;
    }

    @Generated
    public void setOperations(OperationMeta[] operations) {
        this.operations = operations;
    }

    @Generated
    public void setTxChangesAfter(LedgerEntryChanges txChangesAfter) {
        this.txChangesAfter = txChangesAfter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMetaV2)) {
            return false;
        }
        TransactionMetaV2 other = (TransactionMetaV2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerEntryChanges this$txChangesBefore = this.getTxChangesBefore();
        LedgerEntryChanges other$txChangesBefore = other.getTxChangesBefore();
        if (this$txChangesBefore == null ? other$txChangesBefore != null : !((Object)this$txChangesBefore).equals(other$txChangesBefore)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOperations(), other.getOperations())) {
            return false;
        }
        LedgerEntryChanges this$txChangesAfter = this.getTxChangesAfter();
        LedgerEntryChanges other$txChangesAfter = other.getTxChangesAfter();
        return !(this$txChangesAfter == null ? other$txChangesAfter != null : !((Object)this$txChangesAfter).equals(other$txChangesAfter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionMetaV2;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerEntryChanges $txChangesBefore = this.getTxChangesBefore();
        result = result * 59 + ($txChangesBefore == null ? 43 : ((Object)$txChangesBefore).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        LedgerEntryChanges $txChangesAfter = this.getTxChangesAfter();
        result = result * 59 + ($txChangesAfter == null ? 43 : ((Object)$txChangesAfter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionMetaV2(txChangesBefore=" + this.getTxChangesBefore() + ", operations=" + Arrays.deepToString(this.getOperations()) + ", txChangesAfter=" + this.getTxChangesAfter() + ")";
    }

    @Generated
    public TransactionMetaV2() {
    }

    @Generated
    public TransactionMetaV2(LedgerEntryChanges txChangesBefore, OperationMeta[] operations, LedgerEntryChanges txChangesAfter) {
        this.txChangesBefore = txChangesBefore;
        this.operations = operations;
        this.txChangesAfter = txChangesAfter;
    }

    @Generated
    public static class TransactionMetaV2Builder {
        @Generated
        private LedgerEntryChanges txChangesBefore;
        @Generated
        private OperationMeta[] operations;
        @Generated
        private LedgerEntryChanges txChangesAfter;

        @Generated
        TransactionMetaV2Builder() {
        }

        @Generated
        public TransactionMetaV2Builder txChangesBefore(LedgerEntryChanges txChangesBefore) {
            this.txChangesBefore = txChangesBefore;
            return this;
        }

        @Generated
        public TransactionMetaV2Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionMetaV2Builder txChangesAfter(LedgerEntryChanges txChangesAfter) {
            this.txChangesAfter = txChangesAfter;
            return this;
        }

        @Generated
        public TransactionMetaV2 build() {
            return new TransactionMetaV2(this.txChangesBefore, this.operations, this.txChangesAfter);
        }

        @Generated
        public String toString() {
            return "TransactionMetaV2.TransactionMetaV2Builder(txChangesBefore=" + this.txChangesBefore + ", operations=" + Arrays.deepToString(this.operations) + ", txChangesAfter=" + this.txChangesAfter + ")";
        }
    }
}

