/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.LiquidityPool;
import org.stellar.sdk.Price;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LiquidityPoolDepositOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.PoolID;

public class LiquidityPoolDepositOperation
extends Operation {
    @NonNull
    private final String liquidityPoolId;
    @NonNull
    private final BigDecimal maxAmountA;
    @NonNull
    private final BigDecimal maxAmountB;
    @NonNull
    private final Price minPrice;
    @NonNull
    private final Price maxPrice;

    public LiquidityPoolDepositOperation(@NonNull Asset assetA, @NonNull BigDecimal maxAmountA, @NonNull Asset assetB, @NonNull BigDecimal maxAmountB, @NonNull Price minPrice, @NonNull Price maxPrice) {
        if (assetA == null) {
            throw new NullPointerException("assetA is marked non-null but is null");
        }
        if (maxAmountA == null) {
            throw new NullPointerException("maxAmountA is marked non-null but is null");
        }
        if (assetB == null) {
            throw new NullPointerException("assetB is marked non-null but is null");
        }
        if (maxAmountB == null) {
            throw new NullPointerException("maxAmountB is marked non-null but is null");
        }
        if (minPrice == null) {
            throw new NullPointerException("minPrice is marked non-null but is null");
        }
        if (maxPrice == null) {
            throw new NullPointerException("maxPrice is marked non-null but is null");
        }
        this.liquidityPoolId = new LiquidityPool(assetA, assetB).getLiquidityPoolId();
        this.maxAmountA = maxAmountA;
        this.maxAmountB = maxAmountB;
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
    }

    public static LiquidityPoolDepositOperation fromXdr(LiquidityPoolDepositOp op) {
        String liquidityPoolId = Util.bytesToHex(op.getLiquidityPoolID().getPoolID().getHash()).toLowerCase();
        BigDecimal maxAmountA = Operation.fromXdrAmount(op.getMaxAmountA().getInt64());
        BigDecimal maxAmountB = Operation.fromXdrAmount(op.getMaxAmountB().getInt64());
        Price minPrice = Price.fromXdr(op.getMinPrice());
        Price maxPrice = Price.fromXdr(op.getMaxPrice());
        return new LiquidityPoolDepositOperation(liquidityPoolId, maxAmountA, maxAmountB, minPrice, maxPrice);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        LiquidityPoolDepositOp op = new LiquidityPoolDepositOp();
        op.setLiquidityPoolID(new PoolID(new Hash(Util.hexToBytes(this.getLiquidityPoolId()))));
        op.setMaxAmountA(new Int64(Operation.toXdrAmount(this.getMaxAmountA())));
        op.setMaxAmountB(new Int64(Operation.toXdrAmount(this.getMaxAmountB())));
        op.setMinPrice(this.getMinPrice().toXdr());
        op.setMaxPrice(this.getMaxPrice().toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.LIQUIDITY_POOL_DEPOSIT);
        body.setLiquidityPoolDepositOp(op);
        return body;
    }

    @Generated
    protected LiquidityPoolDepositOperation(LiquidityPoolDepositOperationBuilder<?, ?> b) {
        super(b);
        this.liquidityPoolId = ((LiquidityPoolDepositOperationBuilder)b).liquidityPoolId;
        if (this.liquidityPoolId == null) {
            throw new NullPointerException("liquidityPoolId is marked non-null but is null");
        }
        this.maxAmountA = ((LiquidityPoolDepositOperationBuilder)b).maxAmountA;
        if (this.maxAmountA == null) {
            throw new NullPointerException("maxAmountA is marked non-null but is null");
        }
        this.maxAmountB = ((LiquidityPoolDepositOperationBuilder)b).maxAmountB;
        if (this.maxAmountB == null) {
            throw new NullPointerException("maxAmountB is marked non-null but is null");
        }
        this.minPrice = ((LiquidityPoolDepositOperationBuilder)b).minPrice;
        if (this.minPrice == null) {
            throw new NullPointerException("minPrice is marked non-null but is null");
        }
        this.maxPrice = ((LiquidityPoolDepositOperationBuilder)b).maxPrice;
        if (this.maxPrice == null) {
            throw new NullPointerException("maxPrice is marked non-null but is null");
        }
    }

    @Generated
    public static LiquidityPoolDepositOperationBuilder<?, ?> builder() {
        return new LiquidityPoolDepositOperationBuilderImpl();
    }

    @Generated
    public LiquidityPoolDepositOperationBuilder<?, ?> toBuilder() {
        return new LiquidityPoolDepositOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getLiquidityPoolId() {
        return this.liquidityPoolId;
    }

    @NonNull
    @Generated
    public BigDecimal getMaxAmountA() {
        return this.maxAmountA;
    }

    @NonNull
    @Generated
    public BigDecimal getMaxAmountB() {
        return this.maxAmountB;
    }

    @NonNull
    @Generated
    public Price getMinPrice() {
        return this.minPrice;
    }

    @NonNull
    @Generated
    public Price getMaxPrice() {
        return this.maxPrice;
    }

    @Generated
    public String toString() {
        return "LiquidityPoolDepositOperation(super=" + super.toString() + ", liquidityPoolId=" + this.getLiquidityPoolId() + ", maxAmountA=" + this.getMaxAmountA() + ", maxAmountB=" + this.getMaxAmountB() + ", minPrice=" + this.getMinPrice() + ", maxPrice=" + this.getMaxPrice() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPoolDepositOperation)) {
            return false;
        }
        LiquidityPoolDepositOperation other = (LiquidityPoolDepositOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$liquidityPoolId = this.getLiquidityPoolId();
        String other$liquidityPoolId = other.getLiquidityPoolId();
        if (this$liquidityPoolId == null ? other$liquidityPoolId != null : !this$liquidityPoolId.equals(other$liquidityPoolId)) {
            return false;
        }
        BigDecimal this$maxAmountA = this.getMaxAmountA();
        BigDecimal other$maxAmountA = other.getMaxAmountA();
        if (this$maxAmountA == null ? other$maxAmountA != null : !((Object)this$maxAmountA).equals(other$maxAmountA)) {
            return false;
        }
        BigDecimal this$maxAmountB = this.getMaxAmountB();
        BigDecimal other$maxAmountB = other.getMaxAmountB();
        if (this$maxAmountB == null ? other$maxAmountB != null : !((Object)this$maxAmountB).equals(other$maxAmountB)) {
            return false;
        }
        Price this$minPrice = this.getMinPrice();
        Price other$minPrice = other.getMinPrice();
        if (this$minPrice == null ? other$minPrice != null : !((Object)this$minPrice).equals(other$minPrice)) {
            return false;
        }
        Price this$maxPrice = this.getMaxPrice();
        Price other$maxPrice = other.getMaxPrice();
        return !(this$maxPrice == null ? other$maxPrice != null : !((Object)this$maxPrice).equals(other$maxPrice));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LiquidityPoolDepositOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $liquidityPoolId = this.getLiquidityPoolId();
        result = result * 59 + ($liquidityPoolId == null ? 43 : $liquidityPoolId.hashCode());
        BigDecimal $maxAmountA = this.getMaxAmountA();
        result = result * 59 + ($maxAmountA == null ? 43 : ((Object)$maxAmountA).hashCode());
        BigDecimal $maxAmountB = this.getMaxAmountB();
        result = result * 59 + ($maxAmountB == null ? 43 : ((Object)$maxAmountB).hashCode());
        Price $minPrice = this.getMinPrice();
        result = result * 59 + ($minPrice == null ? 43 : ((Object)$minPrice).hashCode());
        Price $maxPrice = this.getMaxPrice();
        result = result * 59 + ($maxPrice == null ? 43 : ((Object)$maxPrice).hashCode());
        return result;
    }

    @Generated
    private LiquidityPoolDepositOperation(@NonNull String liquidityPoolId, @NonNull BigDecimal maxAmountA, @NonNull BigDecimal maxAmountB, @NonNull Price minPrice, @NonNull Price maxPrice) {
        if (liquidityPoolId == null) {
            throw new NullPointerException("liquidityPoolId is marked non-null but is null");
        }
        if (maxAmountA == null) {
            throw new NullPointerException("maxAmountA is marked non-null but is null");
        }
        if (maxAmountB == null) {
            throw new NullPointerException("maxAmountB is marked non-null but is null");
        }
        if (minPrice == null) {
            throw new NullPointerException("minPrice is marked non-null but is null");
        }
        if (maxPrice == null) {
            throw new NullPointerException("maxPrice is marked non-null but is null");
        }
        this.liquidityPoolId = liquidityPoolId;
        this.maxAmountA = maxAmountA;
        this.maxAmountB = maxAmountB;
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
    }

    public static abstract class LiquidityPoolDepositOperationBuilder<C extends LiquidityPoolDepositOperation, B extends LiquidityPoolDepositOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String liquidityPoolId;
        @Generated
        private BigDecimal maxAmountA;
        @Generated
        private BigDecimal maxAmountB;
        @Generated
        private Price minPrice;
        @Generated
        private Price maxPrice;

        public B liquidityPoolId(@NonNull String liquidityPoolId) {
            if (liquidityPoolId == null) {
                throw new NullPointerException("liquidityPoolId is marked non-null but is null");
            }
            this.liquidityPoolId = liquidityPoolId.toLowerCase();
            return (B)this.self();
        }

        public B maxAmountA(@NonNull BigDecimal maxAmountA) {
            if (maxAmountA == null) {
                throw new NullPointerException("maxAmountA is marked non-null but is null");
            }
            this.maxAmountA = Operation.formatAmountScale(maxAmountA);
            return (B)this.self();
        }

        public B maxAmountB(@NonNull BigDecimal maxAmountB) {
            if (maxAmountB == null) {
                throw new NullPointerException("maxAmountB is marked non-null but is null");
            }
            this.maxAmountB = Operation.formatAmountScale(maxAmountB);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LiquidityPoolDepositOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LiquidityPoolDepositOperation instance, LiquidityPoolDepositOperationBuilder<?, ?> b) {
            b.liquidityPoolId(instance.liquidityPoolId);
            b.maxAmountA(instance.maxAmountA);
            b.maxAmountB(instance.maxAmountB);
            b.minPrice(instance.minPrice);
            b.maxPrice(instance.maxPrice);
        }

        @Generated
        public B minPrice(@NonNull Price minPrice) {
            if (minPrice == null) {
                throw new NullPointerException("minPrice is marked non-null but is null");
            }
            this.minPrice = minPrice;
            return (B)this.self();
        }

        @Generated
        public B maxPrice(@NonNull Price maxPrice) {
            if (maxPrice == null) {
                throw new NullPointerException("maxPrice is marked non-null but is null");
            }
            this.maxPrice = maxPrice;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "LiquidityPoolDepositOperation.LiquidityPoolDepositOperationBuilder(super=" + super.toString() + ", liquidityPoolId=" + this.liquidityPoolId + ", maxAmountA=" + this.maxAmountA + ", maxAmountB=" + this.maxAmountB + ", minPrice=" + this.minPrice + ", maxPrice=" + this.maxPrice + ")";
        }
    }

    @Generated
    private static final class LiquidityPoolDepositOperationBuilderImpl
    extends LiquidityPoolDepositOperationBuilder<LiquidityPoolDepositOperation, LiquidityPoolDepositOperationBuilderImpl> {
        @Generated
        private LiquidityPoolDepositOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected LiquidityPoolDepositOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LiquidityPoolDepositOperation build() {
            return new LiquidityPoolDepositOperation(this);
        }
    }
}

