/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractEventType implements XdrElement
{
    SYSTEM(0),
    CONTRACT(1),
    DIAGNOSTIC(2);

    private final int value;

    private ContractEventType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractEventType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SYSTEM;
            }
            case 1: {
                return CONTRACT;
            }
            case 2: {
                return DIAGNOSTIC;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ContractEventType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractEventType.fromXdrByteArray(bytes);
    }

    public static ContractEventType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractEventType.decode(xdrDataInputStream);
    }
}

