/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.MuxedAccount;
import org.stellar.sdk.xdr.TransactionV1Envelope;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class FeeBumpTransaction
implements XdrElement {
    private MuxedAccount feeSource;
    private Int64 fee;
    private FeeBumpTransactionInnerTx innerTx;
    private FeeBumpTransactionExt ext;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.feeSource.encode(stream);
        this.fee.encode(stream);
        this.innerTx.encode(stream);
        this.ext.encode(stream);
    }

    public static FeeBumpTransaction decode(XdrDataInputStream stream) throws IOException {
        FeeBumpTransaction decodedFeeBumpTransaction = new FeeBumpTransaction();
        decodedFeeBumpTransaction.feeSource = MuxedAccount.decode(stream);
        decodedFeeBumpTransaction.fee = Int64.decode(stream);
        decodedFeeBumpTransaction.innerTx = FeeBumpTransactionInnerTx.decode(stream);
        decodedFeeBumpTransaction.ext = FeeBumpTransactionExt.decode(stream);
        return decodedFeeBumpTransaction;
    }

    public static FeeBumpTransaction fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return FeeBumpTransaction.fromXdrByteArray(bytes);
    }

    public static FeeBumpTransaction fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return FeeBumpTransaction.decode(xdrDataInputStream);
    }

    @Generated
    public static FeeBumpTransactionBuilder builder() {
        return new FeeBumpTransactionBuilder();
    }

    @Generated
    public FeeBumpTransactionBuilder toBuilder() {
        return new FeeBumpTransactionBuilder().feeSource(this.feeSource).fee(this.fee).innerTx(this.innerTx).ext(this.ext);
    }

    @Generated
    public MuxedAccount getFeeSource() {
        return this.feeSource;
    }

    @Generated
    public Int64 getFee() {
        return this.fee;
    }

    @Generated
    public FeeBumpTransactionInnerTx getInnerTx() {
        return this.innerTx;
    }

    @Generated
    public FeeBumpTransactionExt getExt() {
        return this.ext;
    }

    @Generated
    public void setFeeSource(MuxedAccount feeSource) {
        this.feeSource = feeSource;
    }

    @Generated
    public void setFee(Int64 fee) {
        this.fee = fee;
    }

    @Generated
    public void setInnerTx(FeeBumpTransactionInnerTx innerTx) {
        this.innerTx = innerTx;
    }

    @Generated
    public void setExt(FeeBumpTransactionExt ext) {
        this.ext = ext;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeeBumpTransaction)) {
            return false;
        }
        FeeBumpTransaction other = (FeeBumpTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MuxedAccount this$feeSource = this.getFeeSource();
        MuxedAccount other$feeSource = other.getFeeSource();
        if (this$feeSource == null ? other$feeSource != null : !((Object)this$feeSource).equals(other$feeSource)) {
            return false;
        }
        Int64 this$fee = this.getFee();
        Int64 other$fee = other.getFee();
        if (this$fee == null ? other$fee != null : !((Object)this$fee).equals(other$fee)) {
            return false;
        }
        FeeBumpTransactionInnerTx this$innerTx = this.getInnerTx();
        FeeBumpTransactionInnerTx other$innerTx = other.getInnerTx();
        if (this$innerTx == null ? other$innerTx != null : !((Object)this$innerTx).equals(other$innerTx)) {
            return false;
        }
        FeeBumpTransactionExt this$ext = this.getExt();
        FeeBumpTransactionExt other$ext = other.getExt();
        return !(this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeeBumpTransaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MuxedAccount $feeSource = this.getFeeSource();
        result = result * 59 + ($feeSource == null ? 43 : ((Object)$feeSource).hashCode());
        Int64 $fee = this.getFee();
        result = result * 59 + ($fee == null ? 43 : ((Object)$fee).hashCode());
        FeeBumpTransactionInnerTx $innerTx = this.getInnerTx();
        result = result * 59 + ($innerTx == null ? 43 : ((Object)$innerTx).hashCode());
        FeeBumpTransactionExt $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FeeBumpTransaction(feeSource=" + this.getFeeSource() + ", fee=" + this.getFee() + ", innerTx=" + this.getInnerTx() + ", ext=" + this.getExt() + ")";
    }

    @Generated
    public FeeBumpTransaction() {
    }

    @Generated
    public FeeBumpTransaction(MuxedAccount feeSource, Int64 fee, FeeBumpTransactionInnerTx innerTx, FeeBumpTransactionExt ext) {
        this.feeSource = feeSource;
        this.fee = fee;
        this.innerTx = innerTx;
        this.ext = ext;
    }

    public static class FeeBumpTransactionInnerTx
    implements XdrElement {
        private EnvelopeType discriminant;
        private TransactionV1Envelope v1;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant.getValue());
            switch (this.discriminant) {
                case ENVELOPE_TYPE_TX: {
                    this.v1.encode(stream);
                }
            }
        }

        public static FeeBumpTransactionInnerTx decode(XdrDataInputStream stream) throws IOException {
            FeeBumpTransactionInnerTx decodedFeeBumpTransactionInnerTx = new FeeBumpTransactionInnerTx();
            EnvelopeType discriminant = EnvelopeType.decode(stream);
            decodedFeeBumpTransactionInnerTx.setDiscriminant(discriminant);
            switch (decodedFeeBumpTransactionInnerTx.getDiscriminant()) {
                case ENVELOPE_TYPE_TX: {
                    decodedFeeBumpTransactionInnerTx.v1 = TransactionV1Envelope.decode(stream);
                }
            }
            return decodedFeeBumpTransactionInnerTx;
        }

        public static FeeBumpTransactionInnerTx fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return FeeBumpTransactionInnerTx.fromXdrByteArray(bytes);
        }

        public static FeeBumpTransactionInnerTx fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return FeeBumpTransactionInnerTx.decode(xdrDataInputStream);
        }

        @Generated
        public static FeeBumpTransactionInnerTxBuilder builder() {
            return new FeeBumpTransactionInnerTxBuilder();
        }

        @Generated
        public FeeBumpTransactionInnerTxBuilder toBuilder() {
            return new FeeBumpTransactionInnerTxBuilder().discriminant(this.discriminant).v1(this.v1);
        }

        @Generated
        public EnvelopeType getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public TransactionV1Envelope getV1() {
            return this.v1;
        }

        @Generated
        public void setDiscriminant(EnvelopeType discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public void setV1(TransactionV1Envelope v1) {
            this.v1 = v1;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeeBumpTransactionInnerTx)) {
                return false;
            }
            FeeBumpTransactionInnerTx other = (FeeBumpTransactionInnerTx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnvelopeType this$discriminant = this.getDiscriminant();
            EnvelopeType other$discriminant = other.getDiscriminant();
            if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
                return false;
            }
            TransactionV1Envelope this$v1 = this.getV1();
            TransactionV1Envelope other$v1 = other.getV1();
            return !(this$v1 == null ? other$v1 != null : !((Object)this$v1).equals(other$v1));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FeeBumpTransactionInnerTx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EnvelopeType $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
            TransactionV1Envelope $v1 = this.getV1();
            result = result * 59 + ($v1 == null ? 43 : ((Object)$v1).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FeeBumpTransaction.FeeBumpTransactionInnerTx(discriminant=" + this.getDiscriminant() + ", v1=" + this.getV1() + ")";
        }

        @Generated
        public FeeBumpTransactionInnerTx() {
        }

        @Generated
        public FeeBumpTransactionInnerTx(EnvelopeType discriminant, TransactionV1Envelope v1) {
            this.discriminant = discriminant;
            this.v1 = v1;
        }

        @Generated
        public static class FeeBumpTransactionInnerTxBuilder {
            @Generated
            private EnvelopeType discriminant;
            @Generated
            private TransactionV1Envelope v1;

            @Generated
            FeeBumpTransactionInnerTxBuilder() {
            }

            @Generated
            public FeeBumpTransactionInnerTxBuilder discriminant(EnvelopeType discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public FeeBumpTransactionInnerTxBuilder v1(TransactionV1Envelope v1) {
                this.v1 = v1;
                return this;
            }

            @Generated
            public FeeBumpTransactionInnerTx build() {
                return new FeeBumpTransactionInnerTx(this.discriminant, this.v1);
            }

            @Generated
            public String toString() {
                return "FeeBumpTransaction.FeeBumpTransactionInnerTx.FeeBumpTransactionInnerTxBuilder(discriminant=" + this.discriminant + ", v1=" + this.v1 + ")";
            }
        }
    }

    public static class FeeBumpTransactionExt
    implements XdrElement {
        private Integer discriminant;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            stream.writeInt(this.discriminant);
            switch (this.discriminant) {
                default: 
            }
        }

        public static FeeBumpTransactionExt decode(XdrDataInputStream stream) throws IOException {
            FeeBumpTransactionExt decodedFeeBumpTransactionExt = new FeeBumpTransactionExt();
            Integer discriminant = stream.readInt();
            decodedFeeBumpTransactionExt.setDiscriminant(discriminant);
            switch (decodedFeeBumpTransactionExt.getDiscriminant()) {
                default: 
            }
            return decodedFeeBumpTransactionExt;
        }

        public static FeeBumpTransactionExt fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return FeeBumpTransactionExt.fromXdrByteArray(bytes);
        }

        public static FeeBumpTransactionExt fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return FeeBumpTransactionExt.decode(xdrDataInputStream);
        }

        @Generated
        public static FeeBumpTransactionExtBuilder builder() {
            return new FeeBumpTransactionExtBuilder();
        }

        @Generated
        public FeeBumpTransactionExtBuilder toBuilder() {
            return new FeeBumpTransactionExtBuilder().discriminant(this.discriminant);
        }

        @Generated
        public Integer getDiscriminant() {
            return this.discriminant;
        }

        @Generated
        public void setDiscriminant(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FeeBumpTransactionExt)) {
                return false;
            }
            FeeBumpTransactionExt other = (FeeBumpTransactionExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$discriminant = this.getDiscriminant();
            Integer other$discriminant = other.getDiscriminant();
            return !(this$discriminant == null ? other$discriminant != null : !((Object)this$discriminant).equals(other$discriminant));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FeeBumpTransactionExt;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $discriminant = this.getDiscriminant();
            result = result * 59 + ($discriminant == null ? 43 : ((Object)$discriminant).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FeeBumpTransaction.FeeBumpTransactionExt(discriminant=" + this.getDiscriminant() + ")";
        }

        @Generated
        public FeeBumpTransactionExt() {
        }

        @Generated
        public FeeBumpTransactionExt(Integer discriminant) {
            this.discriminant = discriminant;
        }

        @Generated
        public static class FeeBumpTransactionExtBuilder {
            @Generated
            private Integer discriminant;

            @Generated
            FeeBumpTransactionExtBuilder() {
            }

            @Generated
            public FeeBumpTransactionExtBuilder discriminant(Integer discriminant) {
                this.discriminant = discriminant;
                return this;
            }

            @Generated
            public FeeBumpTransactionExt build() {
                return new FeeBumpTransactionExt(this.discriminant);
            }

            @Generated
            public String toString() {
                return "FeeBumpTransaction.FeeBumpTransactionExt.FeeBumpTransactionExtBuilder(discriminant=" + this.discriminant + ")";
            }
        }
    }

    @Generated
    public static class FeeBumpTransactionBuilder {
        @Generated
        private MuxedAccount feeSource;
        @Generated
        private Int64 fee;
        @Generated
        private FeeBumpTransactionInnerTx innerTx;
        @Generated
        private FeeBumpTransactionExt ext;

        @Generated
        FeeBumpTransactionBuilder() {
        }

        @Generated
        public FeeBumpTransactionBuilder feeSource(MuxedAccount feeSource) {
            this.feeSource = feeSource;
            return this;
        }

        @Generated
        public FeeBumpTransactionBuilder fee(Int64 fee) {
            this.fee = fee;
            return this;
        }

        @Generated
        public FeeBumpTransactionBuilder innerTx(FeeBumpTransactionInnerTx innerTx) {
            this.innerTx = innerTx;
            return this;
        }

        @Generated
        public FeeBumpTransactionBuilder ext(FeeBumpTransactionExt ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public FeeBumpTransaction build() {
            return new FeeBumpTransaction(this.feeSource, this.fee, this.innerTx, this.ext);
        }

        @Generated
        public String toString() {
            return "FeeBumpTransaction.FeeBumpTransactionBuilder(feeSource=" + this.feeSource + ", fee=" + this.fee + ", innerTx=" + this.innerTx + ", ext=" + this.ext + ")";
        }
    }
}

