// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * AccountEntryExtensionV3's original definition in the XDR file is:
 *
 * <pre>
 * struct AccountEntryExtensionV3
 * {
 *     // We can use this to add more fields, or because it is first, to
 *     // change AccountEntryExtensionV3 into a union.
 *     ExtensionPoint ext;
 *
 *     // Ledger number at which `seqNum` took on its present value.
 *     uint32 seqLedger;
 *
 *     // Time at which `seqNum` took on its present value.
 *     TimePoint seqTime;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class AccountEntryExtensionV3 implements XdrElement {
  private ExtensionPoint ext;
  private Uint32 seqLedger;
  private TimePoint seqTime;

  public void encode(XdrDataOutputStream stream) throws IOException {
    ext.encode(stream);
    seqLedger.encode(stream);
    seqTime.encode(stream);
  }

  public static AccountEntryExtensionV3 decode(XdrDataInputStream stream) throws IOException {
    AccountEntryExtensionV3 decodedAccountEntryExtensionV3 = new AccountEntryExtensionV3();
    decodedAccountEntryExtensionV3.ext = ExtensionPoint.decode(stream);
    decodedAccountEntryExtensionV3.seqLedger = Uint32.decode(stream);
    decodedAccountEntryExtensionV3.seqTime = TimePoint.decode(stream);
    return decodedAccountEntryExtensionV3;
  }

  public static AccountEntryExtensionV3 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static AccountEntryExtensionV3 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
