// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Int256Parts's original definition in the XDR file is:
 *
 * <pre>
 * struct Int256Parts {
 *     int64 hi_hi;
 *     uint64 hi_lo;
 *     uint64 lo_hi;
 *     uint64 lo_lo;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Int256Parts implements XdrElement {
  private Int64 hi_hi;
  private Uint64 hi_lo;
  private Uint64 lo_hi;
  private Uint64 lo_lo;

  public void encode(XdrDataOutputStream stream) throws IOException {
    hi_hi.encode(stream);
    hi_lo.encode(stream);
    lo_hi.encode(stream);
    lo_lo.encode(stream);
  }

  public static Int256Parts decode(XdrDataInputStream stream) throws IOException {
    Int256Parts decodedInt256Parts = new Int256Parts();
    decodedInt256Parts.hi_hi = Int64.decode(stream);
    decodedInt256Parts.hi_lo = Uint64.decode(stream);
    decodedInt256Parts.lo_hi = Uint64.decode(stream);
    decodedInt256Parts.lo_lo = Uint64.decode(stream);
    return decodedInt256Parts;
  }

  public static Int256Parts fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Int256Parts fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
