// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Memo's original definition in the XDR file is:
 *
 * <pre>
 * union Memo switch (MemoType type)
 * {
 * case MEMO_NONE:
 *     void;
 * case MEMO_TEXT:
 *     string text&lt;28&gt;;
 * case MEMO_ID:
 *     uint64 id;
 * case MEMO_HASH:
 *     Hash hash; // the hash of what to pull from the content server
 * case MEMO_RETURN:
 *     Hash retHash; // the hash of the tx you are rejecting
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Memo implements XdrElement {
  private MemoType discriminant;
  private XdrString text;
  private Uint64 id;
  private Hash hash;
  private Hash retHash;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case MEMO_NONE:
        break;
      case MEMO_TEXT:
        text.encode(stream);
        break;
      case MEMO_ID:
        id.encode(stream);
        break;
      case MEMO_HASH:
        hash.encode(stream);
        break;
      case MEMO_RETURN:
        retHash.encode(stream);
        break;
    }
  }

  public static Memo decode(XdrDataInputStream stream) throws IOException {
    Memo decodedMemo = new Memo();
    MemoType discriminant = MemoType.decode(stream);
    decodedMemo.setDiscriminant(discriminant);
    switch (decodedMemo.getDiscriminant()) {
      case MEMO_NONE:
        break;
      case MEMO_TEXT:
        decodedMemo.text = XdrString.decode(stream, 28);
        break;
      case MEMO_ID:
        decodedMemo.id = Uint64.decode(stream);
        break;
      case MEMO_HASH:
        decodedMemo.hash = Hash.decode(stream);
        break;
      case MEMO_RETURN:
        decodedMemo.retHash = Hash.decode(stream);
        break;
    }
    return decodedMemo;
  }

  public static Memo fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Memo fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
