// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Operation's original definition in the XDR file is:
 *
 * <pre>
 * struct Operation
 * {
 *     // sourceAccount is the account used to run the operation
 *     // if not set, the runtime defaults to "sourceAccount" specified at
 *     // the transaction level
 *     MuxedAccount&#42; sourceAccount;
 *
 *     union switch (OperationType type)
 *     {
 *     case CREATE_ACCOUNT:
 *         CreateAccountOp createAccountOp;
 *     case PAYMENT:
 *         PaymentOp paymentOp;
 *     case PATH_PAYMENT_STRICT_RECEIVE:
 *         PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
 *     case MANAGE_SELL_OFFER:
 *         ManageSellOfferOp manageSellOfferOp;
 *     case CREATE_PASSIVE_SELL_OFFER:
 *         CreatePassiveSellOfferOp createPassiveSellOfferOp;
 *     case SET_OPTIONS:
 *         SetOptionsOp setOptionsOp;
 *     case CHANGE_TRUST:
 *         ChangeTrustOp changeTrustOp;
 *     case ALLOW_TRUST:
 *         AllowTrustOp allowTrustOp;
 *     case ACCOUNT_MERGE:
 *         MuxedAccount destination;
 *     case INFLATION:
 *         void;
 *     case MANAGE_DATA:
 *         ManageDataOp manageDataOp;
 *     case BUMP_SEQUENCE:
 *         BumpSequenceOp bumpSequenceOp;
 *     case MANAGE_BUY_OFFER:
 *         ManageBuyOfferOp manageBuyOfferOp;
 *     case PATH_PAYMENT_STRICT_SEND:
 *         PathPaymentStrictSendOp pathPaymentStrictSendOp;
 *     case CREATE_CLAIMABLE_BALANCE:
 *         CreateClaimableBalanceOp createClaimableBalanceOp;
 *     case CLAIM_CLAIMABLE_BALANCE:
 *         ClaimClaimableBalanceOp claimClaimableBalanceOp;
 *     case BEGIN_SPONSORING_FUTURE_RESERVES:
 *         BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
 *     case END_SPONSORING_FUTURE_RESERVES:
 *         void;
 *     case REVOKE_SPONSORSHIP:
 *         RevokeSponsorshipOp revokeSponsorshipOp;
 *     case CLAWBACK:
 *         ClawbackOp clawbackOp;
 *     case CLAWBACK_CLAIMABLE_BALANCE:
 *         ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
 *     case SET_TRUST_LINE_FLAGS:
 *         SetTrustLineFlagsOp setTrustLineFlagsOp;
 *     case LIQUIDITY_POOL_DEPOSIT:
 *         LiquidityPoolDepositOp liquidityPoolDepositOp;
 *     case LIQUIDITY_POOL_WITHDRAW:
 *         LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;
 *     case INVOKE_HOST_FUNCTION:
 *         InvokeHostFunctionOp invokeHostFunctionOp;
 *     case EXTEND_FOOTPRINT_TTL:
 *         ExtendFootprintTTLOp extendFootprintTTLOp;
 *     case RESTORE_FOOTPRINT:
 *         RestoreFootprintOp restoreFootprintOp;
 *     }
 *     body;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class Operation implements XdrElement {
  private MuxedAccount sourceAccount;
  private OperationBody body;

  public void encode(XdrDataOutputStream stream) throws IOException {
    if (sourceAccount != null) {
      stream.writeInt(1);
      sourceAccount.encode(stream);
    } else {
      stream.writeInt(0);
    }
    body.encode(stream);
  }

  public static Operation decode(XdrDataInputStream stream) throws IOException {
    Operation decodedOperation = new Operation();
    int sourceAccountPresent = stream.readInt();
    if (sourceAccountPresent != 0) {
      decodedOperation.sourceAccount = MuxedAccount.decode(stream);
    }
    decodedOperation.body = OperationBody.decode(stream);
    return decodedOperation;
  }

  public static Operation fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Operation fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * OperationBody's original definition in the XDR file is:
   *
   * <pre>
   * union switch (OperationType type)
   *     {
   *     case CREATE_ACCOUNT:
   *         CreateAccountOp createAccountOp;
   *     case PAYMENT:
   *         PaymentOp paymentOp;
   *     case PATH_PAYMENT_STRICT_RECEIVE:
   *         PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
   *     case MANAGE_SELL_OFFER:
   *         ManageSellOfferOp manageSellOfferOp;
   *     case CREATE_PASSIVE_SELL_OFFER:
   *         CreatePassiveSellOfferOp createPassiveSellOfferOp;
   *     case SET_OPTIONS:
   *         SetOptionsOp setOptionsOp;
   *     case CHANGE_TRUST:
   *         ChangeTrustOp changeTrustOp;
   *     case ALLOW_TRUST:
   *         AllowTrustOp allowTrustOp;
   *     case ACCOUNT_MERGE:
   *         MuxedAccount destination;
   *     case INFLATION:
   *         void;
   *     case MANAGE_DATA:
   *         ManageDataOp manageDataOp;
   *     case BUMP_SEQUENCE:
   *         BumpSequenceOp bumpSequenceOp;
   *     case MANAGE_BUY_OFFER:
   *         ManageBuyOfferOp manageBuyOfferOp;
   *     case PATH_PAYMENT_STRICT_SEND:
   *         PathPaymentStrictSendOp pathPaymentStrictSendOp;
   *     case CREATE_CLAIMABLE_BALANCE:
   *         CreateClaimableBalanceOp createClaimableBalanceOp;
   *     case CLAIM_CLAIMABLE_BALANCE:
   *         ClaimClaimableBalanceOp claimClaimableBalanceOp;
   *     case BEGIN_SPONSORING_FUTURE_RESERVES:
   *         BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
   *     case END_SPONSORING_FUTURE_RESERVES:
   *         void;
   *     case REVOKE_SPONSORSHIP:
   *         RevokeSponsorshipOp revokeSponsorshipOp;
   *     case CLAWBACK:
   *         ClawbackOp clawbackOp;
   *     case CLAWBACK_CLAIMABLE_BALANCE:
   *         ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
   *     case SET_TRUST_LINE_FLAGS:
   *         SetTrustLineFlagsOp setTrustLineFlagsOp;
   *     case LIQUIDITY_POOL_DEPOSIT:
   *         LiquidityPoolDepositOp liquidityPoolDepositOp;
   *     case LIQUIDITY_POOL_WITHDRAW:
   *         LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;
   *     case INVOKE_HOST_FUNCTION:
   *         InvokeHostFunctionOp invokeHostFunctionOp;
   *     case EXTEND_FOOTPRINT_TTL:
   *         ExtendFootprintTTLOp extendFootprintTTLOp;
   *     case RESTORE_FOOTPRINT:
   *         RestoreFootprintOp restoreFootprintOp;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class OperationBody implements XdrElement {
    private OperationType discriminant;
    private CreateAccountOp createAccountOp;
    private PaymentOp paymentOp;
    private PathPaymentStrictReceiveOp pathPaymentStrictReceiveOp;
    private ManageSellOfferOp manageSellOfferOp;
    private CreatePassiveSellOfferOp createPassiveSellOfferOp;
    private SetOptionsOp setOptionsOp;
    private ChangeTrustOp changeTrustOp;
    private AllowTrustOp allowTrustOp;
    private MuxedAccount destination;
    private ManageDataOp manageDataOp;
    private BumpSequenceOp bumpSequenceOp;
    private ManageBuyOfferOp manageBuyOfferOp;
    private PathPaymentStrictSendOp pathPaymentStrictSendOp;
    private CreateClaimableBalanceOp createClaimableBalanceOp;
    private ClaimClaimableBalanceOp claimClaimableBalanceOp;
    private BeginSponsoringFutureReservesOp beginSponsoringFutureReservesOp;
    private RevokeSponsorshipOp revokeSponsorshipOp;
    private ClawbackOp clawbackOp;
    private ClawbackClaimableBalanceOp clawbackClaimableBalanceOp;
    private SetTrustLineFlagsOp setTrustLineFlagsOp;
    private LiquidityPoolDepositOp liquidityPoolDepositOp;
    private LiquidityPoolWithdrawOp liquidityPoolWithdrawOp;
    private InvokeHostFunctionOp invokeHostFunctionOp;
    private ExtendFootprintTTLOp extendFootprintTTLOp;
    private RestoreFootprintOp restoreFootprintOp;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case CREATE_ACCOUNT:
          createAccountOp.encode(stream);
          break;
        case PAYMENT:
          paymentOp.encode(stream);
          break;
        case PATH_PAYMENT_STRICT_RECEIVE:
          pathPaymentStrictReceiveOp.encode(stream);
          break;
        case MANAGE_SELL_OFFER:
          manageSellOfferOp.encode(stream);
          break;
        case CREATE_PASSIVE_SELL_OFFER:
          createPassiveSellOfferOp.encode(stream);
          break;
        case SET_OPTIONS:
          setOptionsOp.encode(stream);
          break;
        case CHANGE_TRUST:
          changeTrustOp.encode(stream);
          break;
        case ALLOW_TRUST:
          allowTrustOp.encode(stream);
          break;
        case ACCOUNT_MERGE:
          destination.encode(stream);
          break;
        case INFLATION:
          break;
        case MANAGE_DATA:
          manageDataOp.encode(stream);
          break;
        case BUMP_SEQUENCE:
          bumpSequenceOp.encode(stream);
          break;
        case MANAGE_BUY_OFFER:
          manageBuyOfferOp.encode(stream);
          break;
        case PATH_PAYMENT_STRICT_SEND:
          pathPaymentStrictSendOp.encode(stream);
          break;
        case CREATE_CLAIMABLE_BALANCE:
          createClaimableBalanceOp.encode(stream);
          break;
        case CLAIM_CLAIMABLE_BALANCE:
          claimClaimableBalanceOp.encode(stream);
          break;
        case BEGIN_SPONSORING_FUTURE_RESERVES:
          beginSponsoringFutureReservesOp.encode(stream);
          break;
        case END_SPONSORING_FUTURE_RESERVES:
          break;
        case REVOKE_SPONSORSHIP:
          revokeSponsorshipOp.encode(stream);
          break;
        case CLAWBACK:
          clawbackOp.encode(stream);
          break;
        case CLAWBACK_CLAIMABLE_BALANCE:
          clawbackClaimableBalanceOp.encode(stream);
          break;
        case SET_TRUST_LINE_FLAGS:
          setTrustLineFlagsOp.encode(stream);
          break;
        case LIQUIDITY_POOL_DEPOSIT:
          liquidityPoolDepositOp.encode(stream);
          break;
        case LIQUIDITY_POOL_WITHDRAW:
          liquidityPoolWithdrawOp.encode(stream);
          break;
        case INVOKE_HOST_FUNCTION:
          invokeHostFunctionOp.encode(stream);
          break;
        case EXTEND_FOOTPRINT_TTL:
          extendFootprintTTLOp.encode(stream);
          break;
        case RESTORE_FOOTPRINT:
          restoreFootprintOp.encode(stream);
          break;
      }
    }

    public static OperationBody decode(XdrDataInputStream stream) throws IOException {
      OperationBody decodedOperationBody = new OperationBody();
      OperationType discriminant = OperationType.decode(stream);
      decodedOperationBody.setDiscriminant(discriminant);
      switch (decodedOperationBody.getDiscriminant()) {
        case CREATE_ACCOUNT:
          decodedOperationBody.createAccountOp = CreateAccountOp.decode(stream);
          break;
        case PAYMENT:
          decodedOperationBody.paymentOp = PaymentOp.decode(stream);
          break;
        case PATH_PAYMENT_STRICT_RECEIVE:
          decodedOperationBody.pathPaymentStrictReceiveOp =
              PathPaymentStrictReceiveOp.decode(stream);
          break;
        case MANAGE_SELL_OFFER:
          decodedOperationBody.manageSellOfferOp = ManageSellOfferOp.decode(stream);
          break;
        case CREATE_PASSIVE_SELL_OFFER:
          decodedOperationBody.createPassiveSellOfferOp = CreatePassiveSellOfferOp.decode(stream);
          break;
        case SET_OPTIONS:
          decodedOperationBody.setOptionsOp = SetOptionsOp.decode(stream);
          break;
        case CHANGE_TRUST:
          decodedOperationBody.changeTrustOp = ChangeTrustOp.decode(stream);
          break;
        case ALLOW_TRUST:
          decodedOperationBody.allowTrustOp = AllowTrustOp.decode(stream);
          break;
        case ACCOUNT_MERGE:
          decodedOperationBody.destination = MuxedAccount.decode(stream);
          break;
        case INFLATION:
          break;
        case MANAGE_DATA:
          decodedOperationBody.manageDataOp = ManageDataOp.decode(stream);
          break;
        case BUMP_SEQUENCE:
          decodedOperationBody.bumpSequenceOp = BumpSequenceOp.decode(stream);
          break;
        case MANAGE_BUY_OFFER:
          decodedOperationBody.manageBuyOfferOp = ManageBuyOfferOp.decode(stream);
          break;
        case PATH_PAYMENT_STRICT_SEND:
          decodedOperationBody.pathPaymentStrictSendOp = PathPaymentStrictSendOp.decode(stream);
          break;
        case CREATE_CLAIMABLE_BALANCE:
          decodedOperationBody.createClaimableBalanceOp = CreateClaimableBalanceOp.decode(stream);
          break;
        case CLAIM_CLAIMABLE_BALANCE:
          decodedOperationBody.claimClaimableBalanceOp = ClaimClaimableBalanceOp.decode(stream);
          break;
        case BEGIN_SPONSORING_FUTURE_RESERVES:
          decodedOperationBody.beginSponsoringFutureReservesOp =
              BeginSponsoringFutureReservesOp.decode(stream);
          break;
        case END_SPONSORING_FUTURE_RESERVES:
          break;
        case REVOKE_SPONSORSHIP:
          decodedOperationBody.revokeSponsorshipOp = RevokeSponsorshipOp.decode(stream);
          break;
        case CLAWBACK:
          decodedOperationBody.clawbackOp = ClawbackOp.decode(stream);
          break;
        case CLAWBACK_CLAIMABLE_BALANCE:
          decodedOperationBody.clawbackClaimableBalanceOp =
              ClawbackClaimableBalanceOp.decode(stream);
          break;
        case SET_TRUST_LINE_FLAGS:
          decodedOperationBody.setTrustLineFlagsOp = SetTrustLineFlagsOp.decode(stream);
          break;
        case LIQUIDITY_POOL_DEPOSIT:
          decodedOperationBody.liquidityPoolDepositOp = LiquidityPoolDepositOp.decode(stream);
          break;
        case LIQUIDITY_POOL_WITHDRAW:
          decodedOperationBody.liquidityPoolWithdrawOp = LiquidityPoolWithdrawOp.decode(stream);
          break;
        case INVOKE_HOST_FUNCTION:
          decodedOperationBody.invokeHostFunctionOp = InvokeHostFunctionOp.decode(stream);
          break;
        case EXTEND_FOOTPRINT_TTL:
          decodedOperationBody.extendFootprintTTLOp = ExtendFootprintTTLOp.decode(stream);
          break;
        case RESTORE_FOOTPRINT:
          decodedOperationBody.restoreFootprintOp = RestoreFootprintOp.decode(stream);
          break;
      }
      return decodedOperationBody;
    }

    public static OperationBody fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static OperationBody fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
