// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PublicKey's original definition in the XDR file is:
 *
 * <pre>
 * union PublicKey switch (PublicKeyType type)
 * {
 * case PUBLIC_KEY_TYPE_ED25519:
 *     uint256 ed25519;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PublicKey implements XdrElement {
  private PublicKeyType discriminant;
  private Uint256 ed25519;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case PUBLIC_KEY_TYPE_ED25519:
        ed25519.encode(stream);
        break;
    }
  }

  public static PublicKey decode(XdrDataInputStream stream) throws IOException {
    PublicKey decodedPublicKey = new PublicKey();
    PublicKeyType discriminant = PublicKeyType.decode(stream);
    decodedPublicKey.setDiscriminant(discriminant);
    switch (decodedPublicKey.getDiscriminant()) {
      case PUBLIC_KEY_TYPE_ED25519:
        decodedPublicKey.ed25519 = Uint256.decode(stream);
        break;
    }
    return decodedPublicKey;
  }

  public static PublicKey fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PublicKey fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
