// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * SCErrorCode's original definition in the XDR file is:
 *
 * <pre>
 * enum SCErrorCode
 * {
 *     SCEC_ARITH_DOMAIN = 0,      // Some arithmetic was undefined (overflow, divide-by-zero).
 *     SCEC_INDEX_BOUNDS = 1,      // Something was indexed beyond its bounds.
 *     SCEC_INVALID_INPUT = 2,     // User provided some otherwise-bad data.
 *     SCEC_MISSING_VALUE = 3,     // Some value was required but not provided.
 *     SCEC_EXISTING_VALUE = 4,    // Some value was provided where not allowed.
 *     SCEC_EXCEEDED_LIMIT = 5,    // Some arbitrary limit -- gas or otherwise -- was hit.
 *     SCEC_INVALID_ACTION = 6,    // Data was valid but action requested was not.
 *     SCEC_INTERNAL_ERROR = 7,    // The host detected an error in its own logic.
 *     SCEC_UNEXPECTED_TYPE = 8,   // Some type wasn't as expected.
 *     SCEC_UNEXPECTED_SIZE = 9    // Something's size wasn't as expected.
 * };
 * </pre>
 */
public enum SCErrorCode implements XdrElement {
  SCEC_ARITH_DOMAIN(0),
  SCEC_INDEX_BOUNDS(1),
  SCEC_INVALID_INPUT(2),
  SCEC_MISSING_VALUE(3),
  SCEC_EXISTING_VALUE(4),
  SCEC_EXCEEDED_LIMIT(5),
  SCEC_INVALID_ACTION(6),
  SCEC_INTERNAL_ERROR(7),
  SCEC_UNEXPECTED_TYPE(8),
  SCEC_UNEXPECTED_SIZE(9);

  private final int value;

  SCErrorCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static SCErrorCode decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return SCEC_ARITH_DOMAIN;
      case 1:
        return SCEC_INDEX_BOUNDS;
      case 2:
        return SCEC_INVALID_INPUT;
      case 3:
        return SCEC_MISSING_VALUE;
      case 4:
        return SCEC_EXISTING_VALUE;
      case 5:
        return SCEC_EXCEEDED_LIMIT;
      case 6:
        return SCEC_INVALID_ACTION;
      case 7:
        return SCEC_INTERNAL_ERROR;
      case 8:
        return SCEC_UNEXPECTED_TYPE;
      case 9:
        return SCEC_UNEXPECTED_SIZE;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static SCErrorCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCErrorCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
