// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCSpecEntry's original definition in the XDR file is:
 *
 * <pre>
 * union SCSpecEntry switch (SCSpecEntryKind kind)
 * {
 * case SC_SPEC_ENTRY_FUNCTION_V0:
 *     SCSpecFunctionV0 functionV0;
 * case SC_SPEC_ENTRY_UDT_STRUCT_V0:
 *     SCSpecUDTStructV0 udtStructV0;
 * case SC_SPEC_ENTRY_UDT_UNION_V0:
 *     SCSpecUDTUnionV0 udtUnionV0;
 * case SC_SPEC_ENTRY_UDT_ENUM_V0:
 *     SCSpecUDTEnumV0 udtEnumV0;
 * case SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0:
 *     SCSpecUDTErrorEnumV0 udtErrorEnumV0;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCSpecEntry implements XdrElement {
  private SCSpecEntryKind discriminant;
  private SCSpecFunctionV0 functionV0;
  private SCSpecUDTStructV0 udtStructV0;
  private SCSpecUDTUnionV0 udtUnionV0;
  private SCSpecUDTEnumV0 udtEnumV0;
  private SCSpecUDTErrorEnumV0 udtErrorEnumV0;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case SC_SPEC_ENTRY_FUNCTION_V0:
        functionV0.encode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_STRUCT_V0:
        udtStructV0.encode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_UNION_V0:
        udtUnionV0.encode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_ENUM_V0:
        udtEnumV0.encode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0:
        udtErrorEnumV0.encode(stream);
        break;
    }
  }

  public static SCSpecEntry decode(XdrDataInputStream stream) throws IOException {
    SCSpecEntry decodedSCSpecEntry = new SCSpecEntry();
    SCSpecEntryKind discriminant = SCSpecEntryKind.decode(stream);
    decodedSCSpecEntry.setDiscriminant(discriminant);
    switch (decodedSCSpecEntry.getDiscriminant()) {
      case SC_SPEC_ENTRY_FUNCTION_V0:
        decodedSCSpecEntry.functionV0 = SCSpecFunctionV0.decode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_STRUCT_V0:
        decodedSCSpecEntry.udtStructV0 = SCSpecUDTStructV0.decode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_UNION_V0:
        decodedSCSpecEntry.udtUnionV0 = SCSpecUDTUnionV0.decode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_ENUM_V0:
        decodedSCSpecEntry.udtEnumV0 = SCSpecUDTEnumV0.decode(stream);
        break;
      case SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0:
        decodedSCSpecEntry.udtErrorEnumV0 = SCSpecUDTErrorEnumV0.decode(stream);
        break;
    }
    return decodedSCSpecEntry;
  }

  public static SCSpecEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCSpecEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
