// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SCSpecUDTStructV0's original definition in the XDR file is:
 *
 * <pre>
 * struct SCSpecUDTStructV0
 * {
 *     string doc&lt;SC_SPEC_DOC_LIMIT&gt;;
 *     string lib&lt;80&gt;;
 *     string name&lt;60&gt;;
 *     SCSpecUDTStructFieldV0 fields&lt;40&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SCSpecUDTStructV0 implements XdrElement {
  private XdrString doc;
  private XdrString lib;
  private XdrString name;
  private SCSpecUDTStructFieldV0[] fields;

  public void encode(XdrDataOutputStream stream) throws IOException {
    doc.encode(stream);
    lib.encode(stream);
    name.encode(stream);
    int fieldsSize = getFields().length;
    stream.writeInt(fieldsSize);
    for (int i = 0; i < fieldsSize; i++) {
      fields[i].encode(stream);
    }
  }

  public static SCSpecUDTStructV0 decode(XdrDataInputStream stream) throws IOException {
    SCSpecUDTStructV0 decodedSCSpecUDTStructV0 = new SCSpecUDTStructV0();
    decodedSCSpecUDTStructV0.doc = XdrString.decode(stream, Constants.SC_SPEC_DOC_LIMIT);
    decodedSCSpecUDTStructV0.lib = XdrString.decode(stream, 80);
    decodedSCSpecUDTStructV0.name = XdrString.decode(stream, 60);
    int fieldsSize = stream.readInt();
    decodedSCSpecUDTStructV0.fields = new SCSpecUDTStructFieldV0[fieldsSize];
    for (int i = 0; i < fieldsSize; i++) {
      decodedSCSpecUDTStructV0.fields[i] = SCSpecUDTStructFieldV0.decode(stream);
    }
    return decodedSCSpecUDTStructV0;
  }

  public static SCSpecUDTStructV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCSpecUDTStructV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
