// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * SignerKeyType's original definition in the XDR file is:
 *
 * <pre>
 * enum SignerKeyType
 * {
 *     SIGNER_KEY_TYPE_ED25519 = KEY_TYPE_ED25519,
 *     SIGNER_KEY_TYPE_PRE_AUTH_TX = KEY_TYPE_PRE_AUTH_TX,
 *     SIGNER_KEY_TYPE_HASH_X = KEY_TYPE_HASH_X,
 *     SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD = KEY_TYPE_ED25519_SIGNED_PAYLOAD
 * };
 * </pre>
 */
public enum SignerKeyType implements XdrElement {
  SIGNER_KEY_TYPE_ED25519(0),
  SIGNER_KEY_TYPE_PRE_AUTH_TX(1),
  SIGNER_KEY_TYPE_HASH_X(2),
  SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD(3);

  private final int value;

  SignerKeyType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static SignerKeyType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return SIGNER_KEY_TYPE_ED25519;
      case 1:
        return SIGNER_KEY_TYPE_PRE_AUTH_TX;
      case 2:
        return SIGNER_KEY_TYPE_HASH_X;
      case 3:
        return SIGNER_KEY_TYPE_ED25519_SIGNED_PAYLOAD;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static SignerKeyType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SignerKeyType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
