// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TopologyResponseBodyV0's original definition in the XDR file is:
 *
 * <pre>
 * struct TopologyResponseBodyV0
 * {
 *     PeerStatList inboundPeers;
 *     PeerStatList outboundPeers;
 *
 *     uint32 totalInboundPeerCount;
 *     uint32 totalOutboundPeerCount;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TopologyResponseBodyV0 implements XdrElement {
  private PeerStatList inboundPeers;
  private PeerStatList outboundPeers;
  private Uint32 totalInboundPeerCount;
  private Uint32 totalOutboundPeerCount;

  public void encode(XdrDataOutputStream stream) throws IOException {
    inboundPeers.encode(stream);
    outboundPeers.encode(stream);
    totalInboundPeerCount.encode(stream);
    totalOutboundPeerCount.encode(stream);
  }

  public static TopologyResponseBodyV0 decode(XdrDataInputStream stream) throws IOException {
    TopologyResponseBodyV0 decodedTopologyResponseBodyV0 = new TopologyResponseBodyV0();
    decodedTopologyResponseBodyV0.inboundPeers = PeerStatList.decode(stream);
    decodedTopologyResponseBodyV0.outboundPeers = PeerStatList.decode(stream);
    decodedTopologyResponseBodyV0.totalInboundPeerCount = Uint32.decode(stream);
    decodedTopologyResponseBodyV0.totalOutboundPeerCount = Uint32.decode(stream);
    return decodedTopologyResponseBodyV0;
  }

  public static TopologyResponseBodyV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TopologyResponseBodyV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
