// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * TransactionMetaV2's original definition in the XDR file is:
 *
 * <pre>
 * struct TransactionMetaV2
 * {
 *     LedgerEntryChanges txChangesBefore; // tx level changes before operations
 *                                         // are applied if any
 *     OperationMeta operations&lt;&gt;;         // meta for each operation
 *     LedgerEntryChanges txChangesAfter;  // tx level changes after operations are
 *                                         // applied if any
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class TransactionMetaV2 implements XdrElement {
  private LedgerEntryChanges txChangesBefore;
  private OperationMeta[] operations;
  private LedgerEntryChanges txChangesAfter;

  public void encode(XdrDataOutputStream stream) throws IOException {
    txChangesBefore.encode(stream);
    int operationsSize = getOperations().length;
    stream.writeInt(operationsSize);
    for (int i = 0; i < operationsSize; i++) {
      operations[i].encode(stream);
    }
    txChangesAfter.encode(stream);
  }

  public static TransactionMetaV2 decode(XdrDataInputStream stream) throws IOException {
    TransactionMetaV2 decodedTransactionMetaV2 = new TransactionMetaV2();
    decodedTransactionMetaV2.txChangesBefore = LedgerEntryChanges.decode(stream);
    int operationsSize = stream.readInt();
    decodedTransactionMetaV2.operations = new OperationMeta[operationsSize];
    for (int i = 0; i < operationsSize; i++) {
      decodedTransactionMetaV2.operations[i] = OperationMeta.decode(stream);
    }
    decodedTransactionMetaV2.txChangesAfter = LedgerEntryChanges.decode(stream);
    return decodedTransactionMetaV2;
  }

  public static TransactionMetaV2 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static TransactionMetaV2 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
