/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Memo;
import org.stellar.sdk.xdr.MemoType;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;

public class MemoId
extends Memo {
    @NonNull
    private final BigInteger id;

    public MemoId(BigInteger id) {
        if (id.compareTo(XdrUnsignedHyperInteger.MIN_VALUE) < 0 || id.compareTo(XdrUnsignedHyperInteger.MAX_VALUE) > 0) {
            throw new IllegalArgumentException("MEMO_ID must be between 0 and 2^64-1");
        }
        this.id = id;
    }

    public MemoId(Long id) {
        this(BigInteger.valueOf(id));
    }

    @Override
    org.stellar.sdk.xdr.Memo toXdr() {
        org.stellar.sdk.xdr.Memo memo = new org.stellar.sdk.xdr.Memo();
        memo.setDiscriminant(MemoType.MEMO_ID);
        Uint64 idXdr = new Uint64(new XdrUnsignedHyperInteger(this.id));
        memo.setId(idXdr);
        return memo;
    }

    public String toString() {
        return this.id.toString();
    }

    @NonNull
    @Generated
    public BigInteger getId() {
        return this.id;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MemoId)) {
            return false;
        }
        MemoId other = (MemoId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$id = this.getId();
        BigInteger other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MemoId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

