/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;

public class TOID {
    private int ledgerSequence;
    private int transactionOrder;
    private int operationIndex;

    public TOID(int ledgerSequence, int transactionOrder, int operationIndex) {
        if (ledgerSequence < 0) {
            throw new IllegalArgumentException("Invalid ledger sequence, it must be between 0 and 2147483647.");
        }
        if (transactionOrder < 0 || transactionOrder > 1048575) {
            throw new IllegalArgumentException("Invalid transaction order, it must be between 0 and 1048575.");
        }
        if (operationIndex < 0 || operationIndex > 4095) {
            throw new IllegalArgumentException("Invalid operation index, it must be between 0 and 4095.");
        }
        this.ledgerSequence = ledgerSequence;
        this.transactionOrder = transactionOrder;
        this.operationIndex = operationIndex;
    }

    public long toInt64() {
        return (long)this.ledgerSequence << 32 | (long)this.transactionOrder << 12 | (long)this.operationIndex;
    }

    public static TOID fromInt64(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("Invalid `value`, it must be between 0 and 9223372036854775807.");
        }
        return new TOID((int)(value >> 32), (int)(value >> 12 & 0xFFFFFL), (int)(value & 0xFFFL));
    }

    public void incrementOperationIndex() {
        if (this.operationIndex == 4095) {
            this.operationIndex = 0;
            ++this.ledgerSequence;
        } else {
            ++this.operationIndex;
        }
    }

    public static TOID afterLedger(int ledgerSequence) {
        return new TOID(ledgerSequence, 1048575, 4095);
    }

    public static TOIDRange ledgerRangeInclusive(int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("Invalid `from` and `to` values, `from` must be less than or equal to `to`.");
        }
        if (from <= 0) {
            throw new IllegalArgumentException("Invalid `from` value, it must be greater than 0.");
        }
        long toidFrom = 0L;
        if (from != 1) {
            toidFrom = new TOID(from, 0, 0).toInt64();
        }
        long toidTo = new TOID(to + 1, 0, 0).toInt64();
        return new TOIDRange(toidFrom, toidTo);
    }

    @Generated
    public int getLedgerSequence() {
        return this.ledgerSequence;
    }

    @Generated
    public int getTransactionOrder() {
        return this.transactionOrder;
    }

    @Generated
    public int getOperationIndex() {
        return this.operationIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TOID)) {
            return false;
        }
        TOID other = (TOID)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLedgerSequence() != other.getLedgerSequence()) {
            return false;
        }
        if (this.getTransactionOrder() != other.getTransactionOrder()) {
            return false;
        }
        return this.getOperationIndex() == other.getOperationIndex();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TOID;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLedgerSequence();
        result = result * 59 + this.getTransactionOrder();
        result = result * 59 + this.getOperationIndex();
        return result;
    }

    @Generated
    public String toString() {
        return "TOID(ledgerSequence=" + this.getLedgerSequence() + ", transactionOrder=" + this.getTransactionOrder() + ", operationIndex=" + this.getOperationIndex() + ")";
    }

    public static final class TOIDRange {
        private final long start;
        private final long end;

        @Generated
        public TOIDRange(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Generated
        public long getStart() {
            return this.start;
        }

        @Generated
        public long getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TOIDRange)) {
                return false;
            }
            TOIDRange other = (TOIDRange)o;
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $start = this.getStart();
            result = result * 59 + (int)($start >>> 32 ^ $start);
            long $end = this.getEnd();
            result = result * 59 + (int)($end >>> 32 ^ $end);
            return result;
        }

        @Generated
        public String toString() {
            return "TOID.TOIDRange(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

