/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.responses.Link;
import org.stellar.sdk.responses.Pageable;
import org.stellar.sdk.responses.Response;
import org.stellar.sdk.xdr.LedgerHeader;

public final class LedgerResponse
extends Response
implements Pageable {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="paging_token")
    private final String pagingToken;
    @SerializedName(value="hash")
    private final String hash;
    @SerializedName(value="prev_hash")
    private final String prevHash;
    @SerializedName(value="sequence")
    private final Long sequence;
    @SerializedName(value="successful_transaction_count")
    private final Integer successfulTransactionCount;
    @SerializedName(value="failed_transaction_count")
    private final Integer failedTransactionCount;
    @SerializedName(value="operation_count")
    private final Integer operationCount;
    @SerializedName(value="tx_set_operation_count")
    private final Integer txSetOperationCount;
    @SerializedName(value="closed_at")
    private final String closedAt;
    @SerializedName(value="total_coins")
    private final String totalCoins;
    @SerializedName(value="fee_pool")
    private final String feePool;
    @SerializedName(value="base_fee_in_stroops")
    private final BigInteger baseFeeInStroops;
    @SerializedName(value="base_reserve_in_stroops")
    private final BigInteger baseReserveInStroops;
    @SerializedName(value="max_tx_set_size")
    private final Integer maxTxSetSize;
    @SerializedName(value="protocol_version")
    private final Integer protocolVersion;
    @SerializedName(value="header_xdr")
    private final String headerXdr;
    @SerializedName(value="_links")
    private final Links links;

    public LedgerHeader parseHeaderXdr() {
        return Util.parseXdr(this.headerXdr, LedgerHeader::fromXdrBase64);
    }

    @Generated
    public LedgerResponse(String id, String pagingToken, String hash, String prevHash, Long sequence, Integer successfulTransactionCount, Integer failedTransactionCount, Integer operationCount, Integer txSetOperationCount, String closedAt, String totalCoins, String feePool, BigInteger baseFeeInStroops, BigInteger baseReserveInStroops, Integer maxTxSetSize, Integer protocolVersion, String headerXdr, Links links) {
        this.id = id;
        this.pagingToken = pagingToken;
        this.hash = hash;
        this.prevHash = prevHash;
        this.sequence = sequence;
        this.successfulTransactionCount = successfulTransactionCount;
        this.failedTransactionCount = failedTransactionCount;
        this.operationCount = operationCount;
        this.txSetOperationCount = txSetOperationCount;
        this.closedAt = closedAt;
        this.totalCoins = totalCoins;
        this.feePool = feePool;
        this.baseFeeInStroops = baseFeeInStroops;
        this.baseReserveInStroops = baseReserveInStroops;
        this.maxTxSetSize = maxTxSetSize;
        this.protocolVersion = protocolVersion;
        this.headerXdr = headerXdr;
        this.links = links;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public String getPagingToken() {
        return this.pagingToken;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getPrevHash() {
        return this.prevHash;
    }

    @Generated
    public Long getSequence() {
        return this.sequence;
    }

    @Generated
    public Integer getSuccessfulTransactionCount() {
        return this.successfulTransactionCount;
    }

    @Generated
    public Integer getFailedTransactionCount() {
        return this.failedTransactionCount;
    }

    @Generated
    public Integer getOperationCount() {
        return this.operationCount;
    }

    @Generated
    public Integer getTxSetOperationCount() {
        return this.txSetOperationCount;
    }

    @Generated
    public String getClosedAt() {
        return this.closedAt;
    }

    @Generated
    public String getTotalCoins() {
        return this.totalCoins;
    }

    @Generated
    public String getFeePool() {
        return this.feePool;
    }

    @Generated
    public BigInteger getBaseFeeInStroops() {
        return this.baseFeeInStroops;
    }

    @Generated
    public BigInteger getBaseReserveInStroops() {
        return this.baseReserveInStroops;
    }

    @Generated
    public Integer getMaxTxSetSize() {
        return this.maxTxSetSize;
    }

    @Generated
    public Integer getProtocolVersion() {
        return this.protocolVersion;
    }

    @Generated
    public String getHeaderXdr() {
        return this.headerXdr;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public String toString() {
        return "LedgerResponse(id=" + this.getId() + ", pagingToken=" + this.getPagingToken() + ", hash=" + this.getHash() + ", prevHash=" + this.getPrevHash() + ", sequence=" + this.getSequence() + ", successfulTransactionCount=" + this.getSuccessfulTransactionCount() + ", failedTransactionCount=" + this.getFailedTransactionCount() + ", operationCount=" + this.getOperationCount() + ", txSetOperationCount=" + this.getTxSetOperationCount() + ", closedAt=" + this.getClosedAt() + ", totalCoins=" + this.getTotalCoins() + ", feePool=" + this.getFeePool() + ", baseFeeInStroops=" + this.getBaseFeeInStroops() + ", baseReserveInStroops=" + this.getBaseReserveInStroops() + ", maxTxSetSize=" + this.getMaxTxSetSize() + ", protocolVersion=" + this.getProtocolVersion() + ", headerXdr=" + this.getHeaderXdr() + ", links=" + this.getLinks() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerResponse)) {
            return false;
        }
        LedgerResponse other = (LedgerResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$sequence = this.getSequence();
        Long other$sequence = other.getSequence();
        if (this$sequence == null ? other$sequence != null : !((Object)this$sequence).equals(other$sequence)) {
            return false;
        }
        Integer this$successfulTransactionCount = this.getSuccessfulTransactionCount();
        Integer other$successfulTransactionCount = other.getSuccessfulTransactionCount();
        if (this$successfulTransactionCount == null ? other$successfulTransactionCount != null : !((Object)this$successfulTransactionCount).equals(other$successfulTransactionCount)) {
            return false;
        }
        Integer this$failedTransactionCount = this.getFailedTransactionCount();
        Integer other$failedTransactionCount = other.getFailedTransactionCount();
        if (this$failedTransactionCount == null ? other$failedTransactionCount != null : !((Object)this$failedTransactionCount).equals(other$failedTransactionCount)) {
            return false;
        }
        Integer this$operationCount = this.getOperationCount();
        Integer other$operationCount = other.getOperationCount();
        if (this$operationCount == null ? other$operationCount != null : !((Object)this$operationCount).equals(other$operationCount)) {
            return false;
        }
        Integer this$txSetOperationCount = this.getTxSetOperationCount();
        Integer other$txSetOperationCount = other.getTxSetOperationCount();
        if (this$txSetOperationCount == null ? other$txSetOperationCount != null : !((Object)this$txSetOperationCount).equals(other$txSetOperationCount)) {
            return false;
        }
        Integer this$maxTxSetSize = this.getMaxTxSetSize();
        Integer other$maxTxSetSize = other.getMaxTxSetSize();
        if (this$maxTxSetSize == null ? other$maxTxSetSize != null : !((Object)this$maxTxSetSize).equals(other$maxTxSetSize)) {
            return false;
        }
        Integer this$protocolVersion = this.getProtocolVersion();
        Integer other$protocolVersion = other.getProtocolVersion();
        if (this$protocolVersion == null ? other$protocolVersion != null : !((Object)this$protocolVersion).equals(other$protocolVersion)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$pagingToken = this.getPagingToken();
        String other$pagingToken = other.getPagingToken();
        if (this$pagingToken == null ? other$pagingToken != null : !this$pagingToken.equals(other$pagingToken)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$prevHash = this.getPrevHash();
        String other$prevHash = other.getPrevHash();
        if (this$prevHash == null ? other$prevHash != null : !this$prevHash.equals(other$prevHash)) {
            return false;
        }
        String this$closedAt = this.getClosedAt();
        String other$closedAt = other.getClosedAt();
        if (this$closedAt == null ? other$closedAt != null : !this$closedAt.equals(other$closedAt)) {
            return false;
        }
        String this$totalCoins = this.getTotalCoins();
        String other$totalCoins = other.getTotalCoins();
        if (this$totalCoins == null ? other$totalCoins != null : !this$totalCoins.equals(other$totalCoins)) {
            return false;
        }
        String this$feePool = this.getFeePool();
        String other$feePool = other.getFeePool();
        if (this$feePool == null ? other$feePool != null : !this$feePool.equals(other$feePool)) {
            return false;
        }
        BigInteger this$baseFeeInStroops = this.getBaseFeeInStroops();
        BigInteger other$baseFeeInStroops = other.getBaseFeeInStroops();
        if (this$baseFeeInStroops == null ? other$baseFeeInStroops != null : !((Object)this$baseFeeInStroops).equals(other$baseFeeInStroops)) {
            return false;
        }
        BigInteger this$baseReserveInStroops = this.getBaseReserveInStroops();
        BigInteger other$baseReserveInStroops = other.getBaseReserveInStroops();
        if (this$baseReserveInStroops == null ? other$baseReserveInStroops != null : !((Object)this$baseReserveInStroops).equals(other$baseReserveInStroops)) {
            return false;
        }
        String this$headerXdr = this.getHeaderXdr();
        String other$headerXdr = other.getHeaderXdr();
        if (this$headerXdr == null ? other$headerXdr != null : !this$headerXdr.equals(other$headerXdr)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LedgerResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequence = this.getSequence();
        result = result * 59 + ($sequence == null ? 43 : ((Object)$sequence).hashCode());
        Integer $successfulTransactionCount = this.getSuccessfulTransactionCount();
        result = result * 59 + ($successfulTransactionCount == null ? 43 : ((Object)$successfulTransactionCount).hashCode());
        Integer $failedTransactionCount = this.getFailedTransactionCount();
        result = result * 59 + ($failedTransactionCount == null ? 43 : ((Object)$failedTransactionCount).hashCode());
        Integer $operationCount = this.getOperationCount();
        result = result * 59 + ($operationCount == null ? 43 : ((Object)$operationCount).hashCode());
        Integer $txSetOperationCount = this.getTxSetOperationCount();
        result = result * 59 + ($txSetOperationCount == null ? 43 : ((Object)$txSetOperationCount).hashCode());
        Integer $maxTxSetSize = this.getMaxTxSetSize();
        result = result * 59 + ($maxTxSetSize == null ? 43 : ((Object)$maxTxSetSize).hashCode());
        Integer $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : ((Object)$protocolVersion).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $pagingToken = this.getPagingToken();
        result = result * 59 + ($pagingToken == null ? 43 : $pagingToken.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $prevHash = this.getPrevHash();
        result = result * 59 + ($prevHash == null ? 43 : $prevHash.hashCode());
        String $closedAt = this.getClosedAt();
        result = result * 59 + ($closedAt == null ? 43 : $closedAt.hashCode());
        String $totalCoins = this.getTotalCoins();
        result = result * 59 + ($totalCoins == null ? 43 : $totalCoins.hashCode());
        String $feePool = this.getFeePool();
        result = result * 59 + ($feePool == null ? 43 : $feePool.hashCode());
        BigInteger $baseFeeInStroops = this.getBaseFeeInStroops();
        result = result * 59 + ($baseFeeInStroops == null ? 43 : ((Object)$baseFeeInStroops).hashCode());
        BigInteger $baseReserveInStroops = this.getBaseReserveInStroops();
        result = result * 59 + ($baseReserveInStroops == null ? 43 : ((Object)$baseReserveInStroops).hashCode());
        String $headerXdr = this.getHeaderXdr();
        result = result * 59 + ($headerXdr == null ? 43 : $headerXdr.hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    public static final class Links {
        @SerializedName(value="self")
        private final Link self;
        @SerializedName(value="transactions")
        private final Link transactions;
        @SerializedName(value="operations")
        private final Link operations;
        @SerializedName(value="payments")
        private final Link payments;
        @SerializedName(value="effects")
        private final Link effects;

        @Generated
        public Links(Link self, Link transactions, Link operations, Link payments, Link effects) {
            this.self = self;
            this.transactions = transactions;
            this.operations = operations;
            this.payments = payments;
            this.effects = effects;
        }

        @Generated
        public Link getSelf() {
            return this.self;
        }

        @Generated
        public Link getTransactions() {
            return this.transactions;
        }

        @Generated
        public Link getOperations() {
            return this.operations;
        }

        @Generated
        public Link getPayments() {
            return this.payments;
        }

        @Generated
        public Link getEffects() {
            return this.effects;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Links)) {
                return false;
            }
            Links other = (Links)o;
            Link this$self = this.getSelf();
            Link other$self = other.getSelf();
            if (this$self == null ? other$self != null : !((Object)this$self).equals(other$self)) {
                return false;
            }
            Link this$transactions = this.getTransactions();
            Link other$transactions = other.getTransactions();
            if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
                return false;
            }
            Link this$operations = this.getOperations();
            Link other$operations = other.getOperations();
            if (this$operations == null ? other$operations != null : !((Object)this$operations).equals(other$operations)) {
                return false;
            }
            Link this$payments = this.getPayments();
            Link other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            Link this$effects = this.getEffects();
            Link other$effects = other.getEffects();
            return !(this$effects == null ? other$effects != null : !((Object)this$effects).equals(other$effects));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $self = this.getSelf();
            result = result * 59 + ($self == null ? 43 : ((Object)$self).hashCode());
            Link $transactions = this.getTransactions();
            result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
            Link $operations = this.getOperations();
            result = result * 59 + ($operations == null ? 43 : ((Object)$operations).hashCode());
            Link $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            Link $effects = this.getEffects();
            result = result * 59 + ($effects == null ? 43 : ((Object)$effects).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LedgerResponse.Links(self=" + this.getSelf() + ", transactions=" + this.getTransactions() + ", operations=" + this.getOperations() + ", payments=" + this.getPayments() + ", effects=" + this.getEffects() + ")";
        }
    }
}

