/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.AssetCode4;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class AlphaNum4
implements XdrElement {
    private AssetCode4 assetCode;
    private AccountID issuer;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.assetCode.encode(stream);
        this.issuer.encode(stream);
    }

    public static AlphaNum4 decode(XdrDataInputStream stream) throws IOException {
        AlphaNum4 decodedAlphaNum4 = new AlphaNum4();
        decodedAlphaNum4.assetCode = AssetCode4.decode(stream);
        decodedAlphaNum4.issuer = AccountID.decode(stream);
        return decodedAlphaNum4;
    }

    public static AlphaNum4 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return AlphaNum4.fromXdrByteArray(bytes);
    }

    public static AlphaNum4 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return AlphaNum4.decode(xdrDataInputStream);
    }

    @Generated
    public static AlphaNum4Builder builder() {
        return new AlphaNum4Builder();
    }

    @Generated
    public AlphaNum4Builder toBuilder() {
        return new AlphaNum4Builder().assetCode(this.assetCode).issuer(this.issuer);
    }

    @Generated
    public AssetCode4 getAssetCode() {
        return this.assetCode;
    }

    @Generated
    public AccountID getIssuer() {
        return this.issuer;
    }

    @Generated
    public void setAssetCode(AssetCode4 assetCode) {
        this.assetCode = assetCode;
    }

    @Generated
    public void setIssuer(AccountID issuer) {
        this.issuer = issuer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlphaNum4)) {
            return false;
        }
        AlphaNum4 other = (AlphaNum4)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AssetCode4 this$assetCode = this.getAssetCode();
        AssetCode4 other$assetCode = other.getAssetCode();
        if (this$assetCode == null ? other$assetCode != null : !((Object)this$assetCode).equals(other$assetCode)) {
            return false;
        }
        AccountID this$issuer = this.getIssuer();
        AccountID other$issuer = other.getIssuer();
        return !(this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlphaNum4;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AssetCode4 $assetCode = this.getAssetCode();
        result = result * 59 + ($assetCode == null ? 43 : ((Object)$assetCode).hashCode());
        AccountID $issuer = this.getIssuer();
        result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AlphaNum4(assetCode=" + this.getAssetCode() + ", issuer=" + this.getIssuer() + ")";
    }

    @Generated
    public AlphaNum4() {
    }

    @Generated
    public AlphaNum4(AssetCode4 assetCode, AccountID issuer) {
        this.assetCode = assetCode;
        this.issuer = issuer;
    }

    @Generated
    public static class AlphaNum4Builder {
        @Generated
        private AssetCode4 assetCode;
        @Generated
        private AccountID issuer;

        @Generated
        AlphaNum4Builder() {
        }

        @Generated
        public AlphaNum4Builder assetCode(AssetCode4 assetCode) {
            this.assetCode = assetCode;
            return this;
        }

        @Generated
        public AlphaNum4Builder issuer(AccountID issuer) {
            this.issuer = issuer;
            return this;
        }

        @Generated
        public AlphaNum4 build() {
            return new AlphaNum4(this.assetCode, this.issuer);
        }

        @Generated
        public String toString() {
            return "AlphaNum4.AlphaNum4Builder(assetCode=" + this.assetCode + ", issuer=" + this.issuer + ")";
        }
    }
}

