/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.ClaimPredicate;
import org.stellar.sdk.xdr.ClaimantType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class Claimant
implements XdrElement {
    private ClaimantType discriminant;
    private ClaimantV0 v0;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CLAIMANT_TYPE_V0: {
                this.v0.encode(stream);
            }
        }
    }

    public static Claimant decode(XdrDataInputStream stream) throws IOException {
        Claimant decodedClaimant = new Claimant();
        ClaimantType discriminant = ClaimantType.decode(stream);
        decodedClaimant.setDiscriminant(discriminant);
        switch (decodedClaimant.getDiscriminant()) {
            case CLAIMANT_TYPE_V0: {
                decodedClaimant.v0 = ClaimantV0.decode(stream);
            }
        }
        return decodedClaimant;
    }

    public static Claimant fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Claimant.fromXdrByteArray(bytes);
    }

    public static Claimant fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Claimant.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimantBuilder builder() {
        return new ClaimantBuilder();
    }

    @Generated
    public ClaimantBuilder toBuilder() {
        return new ClaimantBuilder().discriminant(this.discriminant).v0(this.v0);
    }

    @Generated
    public ClaimantType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public ClaimantV0 getV0() {
        return this.v0;
    }

    @Generated
    public void setDiscriminant(ClaimantType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(ClaimantV0 v0) {
        this.v0 = v0;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Claimant)) {
            return false;
        }
        Claimant other = (Claimant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClaimantType this$discriminant = this.getDiscriminant();
        ClaimantType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        ClaimantV0 this$v0 = this.getV0();
        ClaimantV0 other$v0 = other.getV0();
        return !(this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Claimant;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClaimantType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        ClaimantV0 $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Claimant(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ")";
    }

    @Generated
    public Claimant() {
    }

    @Generated
    public Claimant(ClaimantType discriminant, ClaimantV0 v0) {
        this.discriminant = discriminant;
        this.v0 = v0;
    }

    public static class ClaimantV0
    implements XdrElement {
        private AccountID destination;
        private ClaimPredicate predicate;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.destination.encode(stream);
            this.predicate.encode(stream);
        }

        public static ClaimantV0 decode(XdrDataInputStream stream) throws IOException {
            ClaimantV0 decodedClaimantV0 = new ClaimantV0();
            decodedClaimantV0.destination = AccountID.decode(stream);
            decodedClaimantV0.predicate = ClaimPredicate.decode(stream);
            return decodedClaimantV0;
        }

        public static ClaimantV0 fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ClaimantV0.fromXdrByteArray(bytes);
        }

        public static ClaimantV0 fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ClaimantV0.decode(xdrDataInputStream);
        }

        @Generated
        public static ClaimantV0Builder builder() {
            return new ClaimantV0Builder();
        }

        @Generated
        public ClaimantV0Builder toBuilder() {
            return new ClaimantV0Builder().destination(this.destination).predicate(this.predicate);
        }

        @Generated
        public AccountID getDestination() {
            return this.destination;
        }

        @Generated
        public ClaimPredicate getPredicate() {
            return this.predicate;
        }

        @Generated
        public void setDestination(AccountID destination) {
            this.destination = destination;
        }

        @Generated
        public void setPredicate(ClaimPredicate predicate) {
            this.predicate = predicate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClaimantV0)) {
                return false;
            }
            ClaimantV0 other = (ClaimantV0)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountID this$destination = this.getDestination();
            AccountID other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
                return false;
            }
            ClaimPredicate this$predicate = this.getPredicate();
            ClaimPredicate other$predicate = other.getPredicate();
            return !(this$predicate == null ? other$predicate != null : !((Object)this$predicate).equals(other$predicate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClaimantV0;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountID $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
            ClaimPredicate $predicate = this.getPredicate();
            result = result * 59 + ($predicate == null ? 43 : ((Object)$predicate).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Claimant.ClaimantV0(destination=" + this.getDestination() + ", predicate=" + this.getPredicate() + ")";
        }

        @Generated
        public ClaimantV0() {
        }

        @Generated
        public ClaimantV0(AccountID destination, ClaimPredicate predicate) {
            this.destination = destination;
            this.predicate = predicate;
        }

        @Generated
        public static class ClaimantV0Builder {
            @Generated
            private AccountID destination;
            @Generated
            private ClaimPredicate predicate;

            @Generated
            ClaimantV0Builder() {
            }

            @Generated
            public ClaimantV0Builder destination(AccountID destination) {
                this.destination = destination;
                return this;
            }

            @Generated
            public ClaimantV0Builder predicate(ClaimPredicate predicate) {
                this.predicate = predicate;
                return this;
            }

            @Generated
            public ClaimantV0 build() {
                return new ClaimantV0(this.destination, this.predicate);
            }

            @Generated
            public String toString() {
                return "Claimant.ClaimantV0.ClaimantV0Builder(destination=" + this.destination + ", predicate=" + this.predicate + ")";
            }
        }
    }

    @Generated
    public static class ClaimantBuilder {
        @Generated
        private ClaimantType discriminant;
        @Generated
        private ClaimantV0 v0;

        @Generated
        ClaimantBuilder() {
        }

        @Generated
        public ClaimantBuilder discriminant(ClaimantType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ClaimantBuilder v0(ClaimantV0 v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public Claimant build() {
            return new Claimant(this.discriminant, this.v0);
        }

        @Generated
        public String toString() {
            return "Claimant.ClaimantBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ")";
        }
    }
}

