/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ClawbackResultCode implements XdrElement
{
    CLAWBACK_SUCCESS(0),
    CLAWBACK_MALFORMED(-1),
    CLAWBACK_NOT_CLAWBACK_ENABLED(-2),
    CLAWBACK_NO_TRUST(-3),
    CLAWBACK_UNDERFUNDED(-4);

    private final int value;

    private ClawbackResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ClawbackResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return CLAWBACK_SUCCESS;
            }
            case -1: {
                return CLAWBACK_MALFORMED;
            }
            case -2: {
                return CLAWBACK_NOT_CLAWBACK_ENABLED;
            }
            case -3: {
                return CLAWBACK_NO_TRUST;
            }
            case -4: {
                return CLAWBACK_UNDERFUNDED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ClawbackResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClawbackResultCode.fromXdrByteArray(bytes);
    }

    public static ClawbackResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClawbackResultCode.decode(xdrDataInputStream);
    }
}

