/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ErrorCode;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;
import org.stellar.sdk.xdr.XdrString;

public class Error
implements XdrElement {
    private ErrorCode code;
    private XdrString msg;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.code.encode(stream);
        this.msg.encode(stream);
    }

    public static Error decode(XdrDataInputStream stream) throws IOException {
        Error decodedError = new Error();
        decodedError.code = ErrorCode.decode(stream);
        decodedError.msg = XdrString.decode(stream, 100);
        return decodedError;
    }

    public static Error fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return Error.fromXdrByteArray(bytes);
    }

    public static Error fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return Error.decode(xdrDataInputStream);
    }

    @Generated
    public static ErrorBuilder builder() {
        return new ErrorBuilder();
    }

    @Generated
    public ErrorBuilder toBuilder() {
        return new ErrorBuilder().code(this.code).msg(this.msg);
    }

    @Generated
    public ErrorCode getCode() {
        return this.code;
    }

    @Generated
    public XdrString getMsg() {
        return this.msg;
    }

    @Generated
    public void setCode(ErrorCode code) {
        this.code = code;
    }

    @Generated
    public void setMsg(XdrString msg) {
        this.msg = msg;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Error)) {
            return false;
        }
        Error other = (Error)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ErrorCode this$code = this.getCode();
        ErrorCode other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        XdrString this$msg = this.getMsg();
        XdrString other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !((Object)this$msg).equals(other$msg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Error;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ErrorCode $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        XdrString $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : ((Object)$msg).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Error(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }

    @Generated
    public Error() {
    }

    @Generated
    public Error(ErrorCode code, XdrString msg) {
        this.code = code;
        this.msg = msg;
    }

    @Generated
    public static class ErrorBuilder {
        @Generated
        private ErrorCode code;
        @Generated
        private XdrString msg;

        @Generated
        ErrorBuilder() {
        }

        @Generated
        public ErrorBuilder code(ErrorCode code) {
            this.code = code;
            return this;
        }

        @Generated
        public ErrorBuilder msg(XdrString msg) {
            this.msg = msg;
            return this;
        }

        @Generated
        public Error build() {
            return new Error(this.code, this.msg);
        }

        @Generated
        public String toString() {
            return "Error.ErrorBuilder(code=" + this.code + ", msg=" + this.msg + ")";
        }
    }
}

