/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.InnerTransactionResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class InnerTransactionResultPair
implements XdrElement {
    private Hash transactionHash;
    private InnerTransactionResult result;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.transactionHash.encode(stream);
        this.result.encode(stream);
    }

    public static InnerTransactionResultPair decode(XdrDataInputStream stream) throws IOException {
        InnerTransactionResultPair decodedInnerTransactionResultPair = new InnerTransactionResultPair();
        decodedInnerTransactionResultPair.transactionHash = Hash.decode(stream);
        decodedInnerTransactionResultPair.result = InnerTransactionResult.decode(stream);
        return decodedInnerTransactionResultPair;
    }

    public static InnerTransactionResultPair fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return InnerTransactionResultPair.fromXdrByteArray(bytes);
    }

    public static InnerTransactionResultPair fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return InnerTransactionResultPair.decode(xdrDataInputStream);
    }

    @Generated
    public static InnerTransactionResultPairBuilder builder() {
        return new InnerTransactionResultPairBuilder();
    }

    @Generated
    public InnerTransactionResultPairBuilder toBuilder() {
        return new InnerTransactionResultPairBuilder().transactionHash(this.transactionHash).result(this.result);
    }

    @Generated
    public Hash getTransactionHash() {
        return this.transactionHash;
    }

    @Generated
    public InnerTransactionResult getResult() {
        return this.result;
    }

    @Generated
    public void setTransactionHash(Hash transactionHash) {
        this.transactionHash = transactionHash;
    }

    @Generated
    public void setResult(InnerTransactionResult result) {
        this.result = result;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InnerTransactionResultPair)) {
            return false;
        }
        InnerTransactionResultPair other = (InnerTransactionResultPair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hash this$transactionHash = this.getTransactionHash();
        Hash other$transactionHash = other.getTransactionHash();
        if (this$transactionHash == null ? other$transactionHash != null : !((Object)this$transactionHash).equals(other$transactionHash)) {
            return false;
        }
        InnerTransactionResult this$result = this.getResult();
        InnerTransactionResult other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InnerTransactionResultPair;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hash $transactionHash = this.getTransactionHash();
        result = result * 59 + ($transactionHash == null ? 43 : ((Object)$transactionHash).hashCode());
        InnerTransactionResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "InnerTransactionResultPair(transactionHash=" + this.getTransactionHash() + ", result=" + this.getResult() + ")";
    }

    @Generated
    public InnerTransactionResultPair() {
    }

    @Generated
    public InnerTransactionResultPair(Hash transactionHash, InnerTransactionResult result) {
        this.transactionHash = transactionHash;
        this.result = result;
    }

    @Generated
    public static class InnerTransactionResultPairBuilder {
        @Generated
        private Hash transactionHash;
        @Generated
        private InnerTransactionResult result;

        @Generated
        InnerTransactionResultPairBuilder() {
        }

        @Generated
        public InnerTransactionResultPairBuilder transactionHash(Hash transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        @Generated
        public InnerTransactionResultPairBuilder result(InnerTransactionResult result) {
            this.result = result;
            return this;
        }

        @Generated
        public InnerTransactionResultPair build() {
            return new InnerTransactionResultPair(this.transactionHash, this.result);
        }

        @Generated
        public String toString() {
            return "InnerTransactionResultPair.InnerTransactionResultPairBuilder(transactionHash=" + this.transactionHash + ", result=" + this.result + ")";
        }
    }
}

