/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum MemoType implements XdrElement
{
    MEMO_NONE(0),
    MEMO_TEXT(1),
    MEMO_ID(2),
    MEMO_HASH(3),
    MEMO_RETURN(4);

    private final int value;

    private MemoType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static MemoType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return MEMO_NONE;
            }
            case 1: {
                return MEMO_TEXT;
            }
            case 2: {
                return MEMO_ID;
            }
            case 3: {
                return MEMO_HASH;
            }
            case 4: {
                return MEMO_RETURN;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static MemoType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return MemoType.fromXdrByteArray(bytes);
    }

    public static MemoType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return MemoType.decode(xdrDataInputStream);
    }
}

