/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.AccountID;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.SCAddressType;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCAddress
implements XdrElement {
    private SCAddressType discriminant;
    private AccountID accountId;
    private Hash contractId;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                this.accountId.encode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                this.contractId.encode(stream);
            }
        }
    }

    public static SCAddress decode(XdrDataInputStream stream) throws IOException {
        SCAddress decodedSCAddress = new SCAddress();
        SCAddressType discriminant = SCAddressType.decode(stream);
        decodedSCAddress.setDiscriminant(discriminant);
        switch (decodedSCAddress.getDiscriminant()) {
            case SC_ADDRESS_TYPE_ACCOUNT: {
                decodedSCAddress.accountId = AccountID.decode(stream);
                break;
            }
            case SC_ADDRESS_TYPE_CONTRACT: {
                decodedSCAddress.contractId = Hash.decode(stream);
            }
        }
        return decodedSCAddress;
    }

    public static SCAddress fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCAddress.fromXdrByteArray(bytes);
    }

    public static SCAddress fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCAddress.decode(xdrDataInputStream);
    }

    @Generated
    public static SCAddressBuilder builder() {
        return new SCAddressBuilder();
    }

    @Generated
    public SCAddressBuilder toBuilder() {
        return new SCAddressBuilder().discriminant(this.discriminant).accountId(this.accountId).contractId(this.contractId);
    }

    @Generated
    public SCAddressType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public AccountID getAccountId() {
        return this.accountId;
    }

    @Generated
    public Hash getContractId() {
        return this.contractId;
    }

    @Generated
    public void setDiscriminant(SCAddressType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setAccountId(AccountID accountId) {
        this.accountId = accountId;
    }

    @Generated
    public void setContractId(Hash contractId) {
        this.contractId = contractId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCAddress)) {
            return false;
        }
        SCAddress other = (SCAddress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SCAddressType this$discriminant = this.getDiscriminant();
        SCAddressType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        AccountID this$accountId = this.getAccountId();
        AccountID other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !((Object)this$accountId).equals(other$accountId)) {
            return false;
        }
        Hash this$contractId = this.getContractId();
        Hash other$contractId = other.getContractId();
        return !(this$contractId == null ? other$contractId != null : !((Object)this$contractId).equals(other$contractId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCAddress;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SCAddressType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        AccountID $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : ((Object)$accountId).hashCode());
        Hash $contractId = this.getContractId();
        result = result * 59 + ($contractId == null ? 43 : ((Object)$contractId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SCAddress(discriminant=" + this.getDiscriminant() + ", accountId=" + this.getAccountId() + ", contractId=" + this.getContractId() + ")";
    }

    @Generated
    public SCAddress() {
    }

    @Generated
    public SCAddress(SCAddressType discriminant, AccountID accountId, Hash contractId) {
        this.discriminant = discriminant;
        this.accountId = accountId;
        this.contractId = contractId;
    }

    @Generated
    public static class SCAddressBuilder {
        @Generated
        private SCAddressType discriminant;
        @Generated
        private AccountID accountId;
        @Generated
        private Hash contractId;

        @Generated
        SCAddressBuilder() {
        }

        @Generated
        public SCAddressBuilder discriminant(SCAddressType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public SCAddressBuilder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        @Generated
        public SCAddressBuilder contractId(Hash contractId) {
            this.contractId = contractId;
            return this;
        }

        @Generated
        public SCAddress build() {
            return new SCAddress(this.discriminant, this.accountId, this.contractId);
        }

        @Generated
        public String toString() {
            return "SCAddress.SCAddressBuilder(discriminant=" + this.discriminant + ", accountId=" + this.accountId + ", contractId=" + this.contractId + ")";
        }
    }
}

