/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SurveyRequestMessage;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SignedSurveyRequestMessage
implements XdrElement {
    private Signature requestSignature;
    private SurveyRequestMessage request;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.requestSignature.encode(stream);
        this.request.encode(stream);
    }

    public static SignedSurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        SignedSurveyRequestMessage decodedSignedSurveyRequestMessage = new SignedSurveyRequestMessage();
        decodedSignedSurveyRequestMessage.requestSignature = Signature.decode(stream);
        decodedSignedSurveyRequestMessage.request = SurveyRequestMessage.decode(stream);
        return decodedSignedSurveyRequestMessage;
    }

    public static SignedSurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SignedSurveyRequestMessage.fromXdrByteArray(bytes);
    }

    public static SignedSurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SignedSurveyRequestMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static SignedSurveyRequestMessageBuilder builder() {
        return new SignedSurveyRequestMessageBuilder();
    }

    @Generated
    public SignedSurveyRequestMessageBuilder toBuilder() {
        return new SignedSurveyRequestMessageBuilder().requestSignature(this.requestSignature).request(this.request);
    }

    @Generated
    public Signature getRequestSignature() {
        return this.requestSignature;
    }

    @Generated
    public SurveyRequestMessage getRequest() {
        return this.request;
    }

    @Generated
    public void setRequestSignature(Signature requestSignature) {
        this.requestSignature = requestSignature;
    }

    @Generated
    public void setRequest(SurveyRequestMessage request) {
        this.request = request;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedSurveyRequestMessage)) {
            return false;
        }
        SignedSurveyRequestMessage other = (SignedSurveyRequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Signature this$requestSignature = this.getRequestSignature();
        Signature other$requestSignature = other.getRequestSignature();
        if (this$requestSignature == null ? other$requestSignature != null : !((Object)this$requestSignature).equals(other$requestSignature)) {
            return false;
        }
        SurveyRequestMessage this$request = this.getRequest();
        SurveyRequestMessage other$request = other.getRequest();
        return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignedSurveyRequestMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Signature $requestSignature = this.getRequestSignature();
        result = result * 59 + ($requestSignature == null ? 43 : ((Object)$requestSignature).hashCode());
        SurveyRequestMessage $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignedSurveyRequestMessage(requestSignature=" + this.getRequestSignature() + ", request=" + this.getRequest() + ")";
    }

    @Generated
    public SignedSurveyRequestMessage() {
    }

    @Generated
    public SignedSurveyRequestMessage(Signature requestSignature, SurveyRequestMessage request) {
        this.requestSignature = requestSignature;
        this.request = request;
    }

    @Generated
    public static class SignedSurveyRequestMessageBuilder {
        @Generated
        private Signature requestSignature;
        @Generated
        private SurveyRequestMessage request;

        @Generated
        SignedSurveyRequestMessageBuilder() {
        }

        @Generated
        public SignedSurveyRequestMessageBuilder requestSignature(Signature requestSignature) {
            this.requestSignature = requestSignature;
            return this;
        }

        @Generated
        public SignedSurveyRequestMessageBuilder request(SurveyRequestMessage request) {
            this.request = request;
            return this;
        }

        @Generated
        public SignedSurveyRequestMessage build() {
            return new SignedSurveyRequestMessage(this.requestSignature, this.request);
        }

        @Generated
        public String toString() {
            return "SignedSurveyRequestMessage.SignedSurveyRequestMessageBuilder(requestSignature=" + this.requestSignature + ", request=" + this.request + ")";
        }
    }
}

