/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.LedgerEntryChanges;
import org.stellar.sdk.xdr.OperationMeta;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TransactionMetaV1
implements XdrElement {
    private LedgerEntryChanges txChanges;
    private OperationMeta[] operations;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.txChanges.encode(stream);
        int operationsSize = this.getOperations().length;
        stream.writeInt(operationsSize);
        for (int i = 0; i < operationsSize; ++i) {
            this.operations[i].encode(stream);
        }
    }

    public static TransactionMetaV1 decode(XdrDataInputStream stream) throws IOException {
        TransactionMetaV1 decodedTransactionMetaV1 = new TransactionMetaV1();
        decodedTransactionMetaV1.txChanges = LedgerEntryChanges.decode(stream);
        int operationsSize = stream.readInt();
        decodedTransactionMetaV1.operations = new OperationMeta[operationsSize];
        for (int i = 0; i < operationsSize; ++i) {
            decodedTransactionMetaV1.operations[i] = OperationMeta.decode(stream);
        }
        return decodedTransactionMetaV1;
    }

    public static TransactionMetaV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TransactionMetaV1.fromXdrByteArray(bytes);
    }

    public static TransactionMetaV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TransactionMetaV1.decode(xdrDataInputStream);
    }

    @Generated
    public static TransactionMetaV1Builder builder() {
        return new TransactionMetaV1Builder();
    }

    @Generated
    public TransactionMetaV1Builder toBuilder() {
        return new TransactionMetaV1Builder().txChanges(this.txChanges).operations(this.operations);
    }

    @Generated
    public LedgerEntryChanges getTxChanges() {
        return this.txChanges;
    }

    @Generated
    public OperationMeta[] getOperations() {
        return this.operations;
    }

    @Generated
    public void setTxChanges(LedgerEntryChanges txChanges) {
        this.txChanges = txChanges;
    }

    @Generated
    public void setOperations(OperationMeta[] operations) {
        this.operations = operations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionMetaV1)) {
            return false;
        }
        TransactionMetaV1 other = (TransactionMetaV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LedgerEntryChanges this$txChanges = this.getTxChanges();
        LedgerEntryChanges other$txChanges = other.getTxChanges();
        if (this$txChanges == null ? other$txChanges != null : !((Object)this$txChanges).equals(other$txChanges)) {
            return false;
        }
        return Arrays.deepEquals(this.getOperations(), other.getOperations());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionMetaV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LedgerEntryChanges $txChanges = this.getTxChanges();
        result = result * 59 + ($txChanges == null ? 43 : ((Object)$txChanges).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getOperations());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionMetaV1(txChanges=" + this.getTxChanges() + ", operations=" + Arrays.deepToString(this.getOperations()) + ")";
    }

    @Generated
    public TransactionMetaV1() {
    }

    @Generated
    public TransactionMetaV1(LedgerEntryChanges txChanges, OperationMeta[] operations) {
        this.txChanges = txChanges;
        this.operations = operations;
    }

    @Generated
    public static class TransactionMetaV1Builder {
        @Generated
        private LedgerEntryChanges txChanges;
        @Generated
        private OperationMeta[] operations;

        @Generated
        TransactionMetaV1Builder() {
        }

        @Generated
        public TransactionMetaV1Builder txChanges(LedgerEntryChanges txChanges) {
            this.txChanges = txChanges;
            return this;
        }

        @Generated
        public TransactionMetaV1Builder operations(OperationMeta[] operations) {
            this.operations = operations;
            return this;
        }

        @Generated
        public TransactionMetaV1 build() {
            return new TransactionMetaV1(this.txChanges, this.operations);
        }

        @Generated
        public String toString() {
            return "TransactionMetaV1.TransactionMetaV1Builder(txChanges=" + this.txChanges + ", operations=" + Arrays.deepToString(this.operations) + ")";
        }
    }
}

