/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;
import org.stellar.sdk.xdr.SignerKey;

public class RevokeSignerSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;
    @NonNull
    private final SignerKey signer;

    public static RevokeSignerSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        String accountId = StrKey.encodeEd25519PublicKey(op.getSigner().getAccountID());
        SignerKey signer = op.getSigner().getSignerKey();
        return new RevokeSignerSponsorshipOperation(accountId, signer);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        RevokeSponsorshipOp.RevokeSponsorshipOpSigner xdrSigner = new RevokeSponsorshipOp.RevokeSponsorshipOpSigner();
        xdrSigner.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        xdrSigner.setSignerKey(this.signer);
        op.setSigner(xdrSigner);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_SIGNER);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeSignerSponsorshipOperation(RevokeSignerSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.accountId = ((RevokeSignerSponsorshipOperationBuilder)b).accountId;
        if (this.accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.signer = ((RevokeSignerSponsorshipOperationBuilder)b).signer;
        if (this.signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeSignerSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeSignerSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeSignerSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeSignerSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @NonNull
    @Generated
    public SignerKey getSigner() {
        return this.signer;
    }

    @Generated
    public String toString() {
        return "RevokeSignerSponsorshipOperation(super=" + super.toString() + ", accountId=" + this.getAccountId() + ", signer=" + this.getSigner() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeSignerSponsorshipOperation)) {
            return false;
        }
        RevokeSignerSponsorshipOperation other = (RevokeSignerSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        SignerKey this$signer = this.getSigner();
        SignerKey other$signer = other.getSigner();
        return !(this$signer == null ? other$signer != null : !((Object)this$signer).equals(other$signer));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeSignerSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        SignerKey $signer = this.getSigner();
        result = result * 59 + ($signer == null ? 43 : ((Object)$signer).hashCode());
        return result;
    }

    @Generated
    private RevokeSignerSponsorshipOperation(@NonNull String accountId, @NonNull SignerKey signer) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        if (signer == null) {
            throw new NullPointerException("signer is marked non-null but is null");
        }
        this.accountId = accountId;
        this.signer = signer;
    }

    @Generated
    public static abstract class RevokeSignerSponsorshipOperationBuilder<C extends RevokeSignerSponsorshipOperation, B extends RevokeSignerSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String accountId;
        @Generated
        private SignerKey signer;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeSignerSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeSignerSponsorshipOperation instance, RevokeSignerSponsorshipOperationBuilder<?, ?> b) {
            b.accountId(instance.accountId);
            b.signer(instance.signer);
        }

        @Generated
        public B accountId(@NonNull String accountId) {
            if (accountId == null) {
                throw new NullPointerException("accountId is marked non-null but is null");
            }
            this.accountId = accountId;
            return (B)this.self();
        }

        @Generated
        public B signer(@NonNull SignerKey signer) {
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            this.signer = signer;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeSignerSponsorshipOperation.RevokeSignerSponsorshipOperationBuilder(super=" + super.toString() + ", accountId=" + this.accountId + ", signer=" + this.signer + ")";
        }
    }

    @Generated
    private static final class RevokeSignerSponsorshipOperationBuilderImpl
    extends RevokeSignerSponsorshipOperationBuilder<RevokeSignerSponsorshipOperation, RevokeSignerSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeSignerSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeSignerSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeSignerSponsorshipOperation build() {
            return new RevokeSignerSponsorshipOperation(this);
        }
    }
}

