/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ColdArchiveHashEntry
implements XdrElement {
    private Uint32 index;
    private Uint32 level;
    private Hash hash;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.index.encode(stream);
        this.level.encode(stream);
        this.hash.encode(stream);
    }

    public static ColdArchiveHashEntry decode(XdrDataInputStream stream) throws IOException {
        ColdArchiveHashEntry decodedColdArchiveHashEntry = new ColdArchiveHashEntry();
        decodedColdArchiveHashEntry.index = Uint32.decode(stream);
        decodedColdArchiveHashEntry.level = Uint32.decode(stream);
        decodedColdArchiveHashEntry.hash = Hash.decode(stream);
        return decodedColdArchiveHashEntry;
    }

    public static ColdArchiveHashEntry fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ColdArchiveHashEntry.fromXdrByteArray(bytes);
    }

    public static ColdArchiveHashEntry fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ColdArchiveHashEntry.decode(xdrDataInputStream);
    }

    @Generated
    public static ColdArchiveHashEntryBuilder builder() {
        return new ColdArchiveHashEntryBuilder();
    }

    @Generated
    public ColdArchiveHashEntryBuilder toBuilder() {
        return new ColdArchiveHashEntryBuilder().index(this.index).level(this.level).hash(this.hash);
    }

    @Generated
    public Uint32 getIndex() {
        return this.index;
    }

    @Generated
    public Uint32 getLevel() {
        return this.level;
    }

    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @Generated
    public void setIndex(Uint32 index) {
        this.index = index;
    }

    @Generated
    public void setLevel(Uint32 level) {
        this.level = level;
    }

    @Generated
    public void setHash(Hash hash) {
        this.hash = hash;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColdArchiveHashEntry)) {
            return false;
        }
        ColdArchiveHashEntry other = (ColdArchiveHashEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$index = this.getIndex();
        Uint32 other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Uint32 this$level = this.getLevel();
        Uint32 other$level = other.getLevel();
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ColdArchiveHashEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Uint32 $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ColdArchiveHashEntry(index=" + this.getIndex() + ", level=" + this.getLevel() + ", hash=" + this.getHash() + ")";
    }

    @Generated
    public ColdArchiveHashEntry() {
    }

    @Generated
    public ColdArchiveHashEntry(Uint32 index, Uint32 level, Hash hash) {
        this.index = index;
        this.level = level;
        this.hash = hash;
    }

    @Generated
    public static class ColdArchiveHashEntryBuilder {
        @Generated
        private Uint32 index;
        @Generated
        private Uint32 level;
        @Generated
        private Hash hash;

        @Generated
        ColdArchiveHashEntryBuilder() {
        }

        @Generated
        public ColdArchiveHashEntryBuilder index(Uint32 index) {
            this.index = index;
            return this;
        }

        @Generated
        public ColdArchiveHashEntryBuilder level(Uint32 level) {
            this.level = level;
            return this;
        }

        @Generated
        public ColdArchiveHashEntryBuilder hash(Hash hash) {
            this.hash = hash;
            return this;
        }

        @Generated
        public ColdArchiveHashEntry build() {
            return new ColdArchiveHashEntry(this.index, this.level, this.hash);
        }

        @Generated
        public String toString() {
            return "ColdArchiveHashEntry.ColdArchiveHashEntryBuilder(index=" + this.index + ", level=" + this.level + ", hash=" + this.hash + ")";
        }
    }
}

